\version "2.22.2"

\header {
  texidoc = "
<p>The placement of fingering numbers can be controlled precisely by
using the property <code>fingeringOrientation</code>.  For fingering
orientation to apply, the fingering command must be used within a chord
construct (<code>&lt;...&gt;</code>), even for single notes. 
Orientation for string numbers and right-hand fingerings may be
controlled in a similar way by using the properties
<code>stringNumberOrientation</code> and
<code>strokeFingerOrientation</code>, respectively.</p>

<p>These properties can be set to a list of one to three values.  They
control whether fingerings may be placed above (if <code>up</code>
appears in the list), below (if <code>down</code> appears), to the left
(if <code>left</code> appears), or to the right (if <code>right</code>
appears).  Conversely, if a location is not listed, no fingering is
placed there.  LilyPond takes these constraints and works out the best
placement for the fingering of the notes of the following chords.  Note
that <code>left</code> and <code>right</code> are mutually exclusive –
fingerings may be placed only on one side or the other, not both.</p> 

"
  doctitle = "Controlling the placement of chord fingerings"
}
\relative c' {
  \set fingeringOrientations = #'(left)
  <c-1 e-3 a-5>4
  \set fingeringOrientations = #'(down)
  <c-1 e-3 a-5>4
  \set fingeringOrientations = #'(down right up)
  <c-1 e-3 a-5>4
  \set fingeringOrientations = #'(up)
  <c-1 e-3 a-5>4
  \set fingeringOrientations = #'(left)
  <c-1>2
  \set fingeringOrientations = #'(down)
  <e-3>2
  \set stringNumberOrientations = #'(up left down)
  <f\3 a\2 c\1>1
  \set strokeFingerOrientations = #'(down right up)
  <c\rightHandFinger 1 e\rightHandFinger 2 c'\rightHandFinger 4 >
}


