\version "2.22.2"

\header {
  texidoc = "
Add a cautionary indication showing that the sustain pedal should
remain pressed after a line break. Syntax is
@code{\\sustainPedal@{[music]@}}.  

"
  doctitle = "Sustain pedal cautionary after line break (alternative)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=1024
%% see also http://lsr.di.unimi.it/LSR/Item?id=1023
%% Credits PPS => http://lilypond.1069038.n5.nabble.com/Sustain-pedal-cautionary-after-line-break-td186551.html

\paper { tagline = ##f }

%%%% Snippet start here:

%% Cautionary pedal mark after a line break:
cautionPedAlter = \markup {
  \normal-text
  \whiteout
  \pad-markup #.1
  \with-dimensions #'(0 . 5.85) #'(0 . 1.8)
  \concat {
    "("
    \musicglyph "pedal.Ped"
    \musicglyph "pedal.."
    ")"
  }
}

%% Span:
sustainPedal =
#(define-music-function (music) (ly:music?)
   (let ((elts (extract-named-music music '(NoteEvent EventChord))))
     (if (pair? elts)
         (let ((first-element (first elts))
               (last-element (last elts)))
           (set! (ly:music-property first-element 'articulations)
                 (cons (make-music 'SustainEvent 'span-direction -1)
                       (ly:music-property first-element 'articulations)))
           (set! (ly:music-property last-element 'articulations)
                 (cons (make-music 'SustainEvent 'span-direction 1)
                       (ly:music-property last-element 'articulations))))))
   #{
      \set Staff.pedalSustainStyle = #'mixed

      \once\override Staff.SustainPedalLineSpanner.stencil =
         #ly:line-spanner::print
      \once\override Staff.SustainPedalLineSpanner.left-bound-info =
         #ly:horizontal-line-spanner::calc-left-bound-info-and-text
      \once\override Staff.SustainPedalLineSpanner.right-bound-info =
         #ly:horizontal-line-spanner::calc-right-bound-info

      \once\override Staff.SustainPedalLineSpanner.staff-padding = #3
      \once\override Staff.SustainPedalLineSpanner.bound-details =
         #`((right (Y . 0)(attach-dir . -1))
            (left  (Y . 0)(padding . 1)(attach-dir .  1))
            (left-broken  (padding . 0) (attach-dir .  1)(text . ,cautionPedAlter)))
      $music
      \unset Staff.pedalSustainStyle
   #})

%% Syntax: \sustainPedSpan { notes }

%% Test:
\relative c'' {
  \sustainPedal { c1 \break c c }
}


