\version "2.22.2"

\header {
  texidoc = "
When you put a long \\markup text in a \\mark object, LilyPond
stretches the measure to encompass the complete markup. This can be
avoided by overriding the 'X-extent property of the RehearsalMark
object, as demonstrated in this snippet. 

"
  doctitle = "Preventing long \\mark objects to stretch a measure"
}
%% http://lsr.di.unimi.it/LSR/Item?id=301

\paper{ 
  indent = 0
}

\new PianoStaff <<
  \new Staff {
    \override Score.RehearsalMark.self-alignment-X = #left
    R1 R1 
    \mark \markup { "long markup with default horizontal extent" } 
    R1*2 
  }
  \new Staff {
    \repeat unfold 16 {
      \clef F
      c4
    }		
  }
>>

\new PianoStaff <<
  \new Staff {
    \override Score.RehearsalMark.self-alignment-X = #left
    R1 R1 
    \mark \markup { "long markup with default horizontal extent" } 
    \override Score.RehearsalMark.X-extent = #'(0 . 0)
    R1*2 
  }
  \new Staff {
    \repeat unfold 16 {
      \clef F
      c4
    }		
  }
>>




