\version "2.22.2"

\header {
  texidoc = "
Syntax is @code{\\markup\\circled-pattern #'radius #'angle #'repeat
'sign (or letter, or glyph) }

"
  doctitle = "Circled pattern markup"
}
%% http://lsr.di.unimi.it/LSR/Item?id=1068
%% Add by P.P.Schneider on July 2018.
%% see disussion => http://lilypond.1069038.n5.nabble.com/dotted-semicircle-indicating-harmonics-td214580.html

%here starts the snippet:

%circled-pattern
#(define-markup-command
  (circled-pattern layout props radius angle num arg)
  (number? number? number? markup?)
  (interpret-markup layout props
   (let* ((rep (abs num))(rad (abs radius)))
    (cond
     ((= num 0) (markup ""))
     ((= num 1) (markup arg))
     (#t (markup
          (#:combine
           (#:null)
           (fold
            (lambda (i prev)
             (markup
               (#:combine
                (#:rotate
                 (* i (/ angle rep))
                 (#:concat (#:null #:hspace rad arg)))
               prev)))
            (markup (#:null))
            (iota (1+ rep))))))))))

#(define-markup-command
  (circled-pattern-iterative layout props radius angle num arg)
  (number? number? number? markup?)
  (interpret-markup layout props
   (let ((rep (abs num)))
    (cond
     ((= num 0) (markup ""))
     ((= num 1) arg)
     (#t (do ((i 0 (1+ i))
              (res (markup (#:null))
                   (markup
                    (#:combine
                     (#:rotate
                      (* i (/ angle rep))
                      (#:concat (#:null #:hspace radius arg)))
                     res))))
             ((= i (1+ rep)) res)))))))


%% Tests:
testOne = \markup "."
testTwo = \markup \rotate #99 \musicglyph "clefs.G" 
testThree = \markup \rotate #110 \fontsize #2 \sans "C" 
testFour = \markup \rotate #105 "^" 
testFive = \markup \scale #'(3 . 1) ">"
testSix = \markup { 
  \circled-pattern #30 #360 #35
  \circled-pattern #15 #180 #20 \sans\bold\rotate #-90 "C"
}

\markup\fill-line {
  %% Test #1
  \circled-pattern-iterative #10 #180 #30 \testOne
  
  \null
  %% Test #1 bis
  \circled-pattern-iterative #10 #-270 #45 \testOne
  
  \null
  %% test #2 (funny)
  \circled-pattern-iterative #6 #360 #8 \testTwo
  
  %% test #3 (red flower)
  \with-color #red \circled-pattern #5 #-360 #10 \testThree
  
  %% Test #4 (snow)
  \rotate #-15 \circled-pattern-iterative #1.5 #360 #6 \testFour
  
  %% Test #5 (star)
  \circled-pattern-iterative #3 #360 #5 \testFive
  
  \null
  %% Test #6 (combination)
  \scale #'(.35 . .35)
  \testSix
}


