\version "2.22.2"

\header {
  texidoc = "
By default, LilyPond chooses the horizontal spacing and stretching so
that the whole score fits into the assigned area. When there are
dynamic signs attached to invisible spacer notes in tightly spaced
scores, their distance might be too small, so that the dynamics either
collide or the second of the dynamic signs is moved up or down to
prevent collisions (see the first measure in the snippet). One can,
however, set a minimum width for that particular measure by using a
parallel voice with an invisible multi-measure rest using the desired
@code{minimum-length}. All other measures will still keep their default
spacing, only this one measure will be stretched a little more (see the
third measure in the snippet).



"
  doctitle = "Setting minimum width (spacing) for one particular measure"
}
%% http://lsr.di.unimi.it/LSR/Item?id=629

\paper {
  line-width = 9\cm
}

spacerVoice = \new Voice {
  \override MultiMeasureRest.transparent = ##t
  \override MultiMeasureRest.minimum-length = #8
  R1
}

\new Voice \relative c' {
  \dynamicUp
  << { c1 } { s2\f s2\p } >> | \noBreak
  f4 e d c | \noBreak
  << { c1 } { s2\f s2\p } \spacerVoice >> | \noBreak
  d2 e | \break
}



