\version "2.22.2"

\header {
  texidoc = "
In some French Baroque music, mainly in slow 3/2 time, a form of
notation using open note heads was used, which is now known as
@qq{white} or @qq{void} notation. This snippet demonstrates such
notation, by setting the property @code{duration-log}. Correct beaming
is obtained by setting the music in 3/4 time and changing the displayed
time signature using @code{timeSignatureFraction}. 

"
  doctitle = "Producing white (void) notation"
}
%% http://lsr.di.unimi.it/LSR/Item?id=440

% from Louis-Antoine Dornel: Trio sonata in F major, op. 3/2 
\relative c''' {
  \time 3/4
  \set Staff.timeSignatureFraction = #'(3 . 2)
  \override NoteHead.duration-log = #1
  a4 a a |
  cis,^\markup { \bold + } cis a |
  f'4. a8[ g f] |
  e4 e8[ f e f] |
  g2. ~ |
  g4 f8 g a4 |
  b4 e,4. fis16 g |
  fis8[ a b a g fis] |
}



