\version "2.22.2"

\header {
  texidoc = "
To increase or decrease the vertical spacing in general (rather than
the spacing of just one particular aspect) you can multiply all of the
default flexible vertical spacing properties by a given scaling factor.
 This approach helps preserve the spacing proportions, as compared with
changing just one or two of these properties.  In this snippet two
variables are used as the scaling factors for (1) within-system spacing
and (2) page layout (outside-system) spacing.

"
  doctitle = "Scaling vertical spacing"
}
% This snippet shows how to increase or decrease the overall vertical spacing
% (of staves, systems, lyrics, chord names, etc.) by scaling all of the properties
% that affect the vertical spacing layout.  This helps preserve the basic
% proportions as compared with changing just one or two of these properties.


% VERTICAL SPACING SETTINGS: PAGE LAYOUT, OUTSIDE OF SYSTEMS

% see Notation Reference 4.1.4
% http://lilypond.org/doc/v2.18/Documentation/notation/flexible-vertical-spacing-paper-variables
% default values are from ly/engraver-init.ly in LilyPond source code

% pmult: page/paper variable multiplier, used in the paper block below to scale
% flexible vertical spacing paper variables. Change its value to change the
% vertical spacing outside of systems.

pmult = #1.5

\paper {
  system-system-spacing =
  #`((basic-distance . ,(* 12 pmult))
     (minimum-distance . ,(* 8 pmult))
     (padding . ,pmult))
  score-system-spacing =
  #`((basic-distance . ,(* 14 pmult))
     (minimum-distance . ,(* 8 pmult))
     (padding . ,pmult))
  markup-system-spacing =
  #`((basic-distance . ,(* 5 pmult))
     (padding . ,(* 0.5 pmult)))
  score-markup-spacing =
  #`((basic-distance . ,(* 12 pmult))
     (padding . ,(* 0.5 pmult)))
  markup-markup-spacing =
  #`((basic-distance . ,pmult)
     (padding . ,(* 0.5 pmult)))
  top-system-spacing =
  % minimum-distance is 0
  #`((basic-distance . ,pmult)
     (padding . ,pmult))
  top-markup-spacing.padding = #pmult
  % basic-distance and minimum-distance are 0
  last-bottom-spacing =
  % minimum-distance is 0
  #`((basic-distance . ,pmult)
     (padding . ,pmult))
}


% VERTICAL SPACING SETTINGS: WITHIN SYSTEMS

% see Notation Reference 4.4.1
% http://lilypond.org/doc/v2.18/Documentation/notation/flexible-vertical-spacing-within-systems
% default values are from scm/define-grobs.scm in LilyPond source code

% gmult: grob property multiplier, used in the layout block below to scale
% flexible vertical spacing grob properties.  Change its value to change the
% vertical spacing within systems.

gmult = #1.5

\layout {
  \context {
    \Score {
      \override StaffGrouper.staff-staff-spacing =
      #`((basic-distance . ,(* 9 gmult))
         (minimum-distance . ,(* 7 gmult))
         (padding . ,gmult))
      \override StaffGrouper.staffgroup-staff-spacing =
      #`((basic-distance . ,(* 10.5 gmult))
         (minimum-distance . ,(* 8 gmult))
         (padding . ,gmult))
    }
  }
  \context {
    \Staff {
      \override VerticalAxisGroup.default-staff-staff-spacing =
      #`((basic-distance . ,(* 9 gmult))
         (minimum-distance . ,(* 8 gmult))
         (padding . ,gmult))
    }
  }
  \context {
    \ChordNames {
      \override VerticalAxisGroup.nonstaff-relatedstaff-spacing.padding = #(* 0.5 gmult)
      \override VerticalAxisGroup.nonstaff-nonstaff-spacing.padding = #(* 0.5 gmult)
    }
  }
  \context {
    \Dynamics {
      \override VerticalAxisGroup.nonstaff-relatedstaff-spacing =
      #`((basic-distance . ,(* 5 gmult))
         (padding . ,(* 0.5 gmult)))
    }
  }
  \context {
    \FiguredBass {
      \override VerticalAxisGroup.nonstaff-relatedstaff-spacing.padding = #(* 0.5 gmult)
      \override VerticalAxisGroup.nonstaff-nonstaff-spacing.padding = #(* 0.5 gmult)
    }
  }
  % FretBoards do not set any grob-properties in VerticalAxisGroup
  % so there is nothing to scale, so they aren't includede here.
  \context {
    \Lyrics {
      \override VerticalAxisGroup.nonstaff-relatedstaff-spacing =
      #`((basic-distance . ,(* 5.5 gmult))
         (padding . ,(* 0.5 gmult)))
      \override VerticalAxisGroup.nonstaff-nonstaff-spacing =
      % basic-distance is 0
      #`((minimum-distance . ,(* 2.8 gmult))
         (padding . ,(* 0.2 gmult)))
      \override VerticalAxisGroup.nonstaff-unrelatedstaff-spacing.padding = #(* 1.5 gmult)
    }
  }
  \context {
    \NoteNames {
      \override VerticalAxisGroup.nonstaff-relatedstaff-spacing =
      #`((basic-distance . ,(* 5.5 gmult))
         (padding . ,(* 0.5 gmult)))
      \override VerticalAxisGroup.nonstaff-nonstaff-spacing =
      % basic-distance is 0
      #`((minimum-distance . ,(* 2.8 gmult))
         (padding . ,(* 0.2 gmult)))
      \override VerticalAxisGroup.nonstaff-unrelatedstaff-spacing.padding = #(* 1.5 gmult)
    }
  }
}


%% EXAMPLE MUSIC

global = { \key c \major \time 4/4 }
somenotes = \repeat unfold 48 { c8[ c] }
chordNames = \chordmode { \global \repeat unfold 12 { c1:m } }
melody = \relative c'' { \global \somenotes }
verse = \lyricmode { \repeat unfold 48 { la la } }
right = \relative c'' { \global \somenotes }
left = \relative c' { \global \somenotes }

\score {
  <<
    <<
      \new ChordNames \chordNames
      \new Staff { \melody }
      \addlyrics { \verse }
    >>
    \new PianoStaff <<
      \new Staff = "right" { \right }
      \new Staff = "left" { \clef bass \left }
    >>
  >>
  \layout { }
}


