\version "2.22.2"

\header {
  texidoc = "
This snippet shows how to draw markers/boxes around objects on
different staves.

Syntax is


  ^\\markup\\myMarker #width #height

or


  ^\\markup\\myBox #width #height 

"
  doctitle = "Draw a box spanning multiple staves"
}
%% http://lsr.di.unimi.it/LSR/Item?id=953
%=> see also http://lilypond.1069038.n5.nabble.com/Draw-a-box-spanning-multiple-staves-tc162643.html

% by P.P.Schneider on October 2014.

\header { tagline = ##f }

\layout {
  \context {
    \Lyrics
    \override LyricText.font-size = #-1
    \override LyricHyphen.minimum-distance = #1.0
  }
  \context {
    \Score
    \omit Clef
    \omit TimeSignature
  }
}

%%% Option No1:
#(define-markup-command (myMarker layout props colorWidth colorHeight) (number? number?)
  (interpret-markup layout props
    (markup #:line (#:with-dimensions (cons 0 0)(cons 0 0) 
                     (#:with-color (list 1.0 1.0 0.0) ;; => yellow
                       ;; other options (e.g.):
                       ;;;; red: 	(list 1.0 0.0 0.0)
                       ;;;; green: 	(list 0.0 1.0 0.0)
                       ;;;; cyan: 	(list 0.0 1.0 1.0)
                       ;;;; magenta: 	(list 1.0 0.0 1.0)
                       ;;;;;; see also: http://lilypond.org/doc/v2.18/Documentation/notation/list-of-colors
                        (#:filled-box (cons -1.7 colorWidth) 
                                      (cons (* -1 colorHeight) 1) 0))))))

\markup\italic "Option 1:"
<<
  <<
    \new Voice = VOne
    \transpose c c' 
    {
      \autoBeamOff
      \time 3/4
      s2 b8 c' |
      aes
      -\tweak layer #-1
      ^\markup\myMarker #7.5 #15 %% #width #height
      aes 
    }
    \new Lyrics
    \lyricsto VOne
    {
      Pyr -- rhas Stam -- me,
    }
  >>
  <<
    \new Voice = VTwo
    \transpose c c' 
    {
      \autoBeamOff
      \time 3/4
      \stopStaff 
      s2. 
      \startStaff
      aes4*1/2 aes aes8 aes aes
    }
    \new Lyrics
    \lyricsto VTwo
    {
      Stam -- me, Ster -- bli -- che
    }
  >>
>>

%%% Option No2:
#(define-markup-command (myBox layout props myWidth myHeight) (number? number?)
  (interpret-markup layout props
    (markup #:line (#:with-dimensions (cons 0 0)(cons 0 0)
      (#:path 0.2
        (list (list (quote moveto) -1.7 1)
        (list (quote lineto) myWidth 1)
        (list (quote lineto) myWidth (* myHeight -1))
        (list (quote lineto) -1.7 (* myHeight -1))
        (list (quote closepath))))))))

\markup { \vspace #2 \italic "Option 2:" }
<<
  <<
    \new Voice = VOne
    \transpose c c' 
    {
      \autoBeamOff
      \time 3/4
      s2 b8 c' |
      aes
      ^\markup\myBox #7.5 #15 %% #width #height
      aes 
    }
    \new Lyrics
    \lyricsto VOne
    {
      Pyr -- rhas Stam -- me,
    }
  >>
  <<
    \new Voice = VTwo
    \transpose c c' 
    {
      \autoBeamOff
      \time 3/4
      \stopStaff 
      s2. 
      \startStaff
      aes4*1/2 aes aes8 aes aes
    }
    \new Lyrics
    \lyricsto VTwo
    {
      Stam -- me, Ster -- bli -- che
    }
  >>
>>



