\version "2.22.2"

\header {
  texidoc = "
Most renaissance and baroque scores use specific symbols for bass
figures, particularly for augmented sixths with a backslash striking
only the upper part of the number six (or sometimes the number nine),
and \"plus\" symbols integrated with the number four (and sometimes the
numbers two or five as well; this notation may also be used for
integrating flat and natural accidentals).


Here is a way to obtain such symbols in the printed output whilst
keeping the usual syntax for figured bass entry. This is done not with
native MetaFont glyphs, but by combining PostScript code (using Scheme
syntax so that SVG output is supported) and additional stencils in
markup definitions.



"
  doctitle = "Figured bass with alternate baroque notation"
}
%% Glyph definitions:

openedSix = \markup
\scale #'(.0045 . .0045)
\override #'(filled . #t) \path #0
#'(
    (moveto 117.5 192)
    (curveto 82.25 192 80 164.25 80 126)
    (lineto 80 85.5)
    (curveto 80 47.25 82.25 19.5 117.5 19.5)
    (curveto 159.5 19.5 161 57 161 105.75)
    (curveto 161 154.5 159.5 192 117.5 192)
    (closepath)
    (moveto 80 201.75)
    (curveto 92 207 104 211.5 117.5 211.5)
    (curveto 194.75 211.5 247.25 177.75 247.25 105.75)
    (curveto 247.25 33.75 194.75 0 117.5 0)
    (curveto 75.125 0 42.688 23.25 20.844 58.312)
    (curveto -16.164 111.789 -2.754 186.469 52.051 249.164)
    (curveto 79.453 280.512 117.207 308.863 164.184 330.07)
    (curveto 211.156 351.281 266.695 381.359 285.328 352.68)
    (curveto 225.148 344.094 166.652 307.07 129.25 276.117)
    (curveto 91.852 245.164 79.973 217.148 80 201.75)
    (closepath))

elongatedTwo = \markup \combine
\scale #'(.0045 . .0045)
\override #'(filled . #t) \path #0
#'(
    (moveto 19.5 6.879)
    (curveto 19.5 6.879 4.566 -11.469 0 10.5)
    (curveto 13.371 124.34 175.5 132.75 175.5 266.25)
    (curveto 175.5 309.75 163.5 355.5 126 355.5)
    (curveto 105 355.5 84.75 345.75 84.75 327)
    (curveto 84.75 306.75 111 297 111 276.75)
    (curveto 111 249 87.75 226.5 60 226.5)
    (curveto 32.25 226.5 9.75 249 9.75 276.75)
    (curveto 9.75 334.5 64.5 375 126 375)
    (curveto 198.75 375 269.289 332.98 267.75 266.25)
    (curveto 265.629 174.344 163.785 139.562 93.676 91.652)
    (curveto 55.66 65.676 19.5 6.879 19.5 6.879)
    (closepath))
\translate #'(.12 . 0) \override #'(thickness . 2.2) \draw-line #'(1.6 . 0)

elongatedFive = \markup  \combine
\scale #'(.0045 . .0045)
\override #'(filled . #t) \path #0
#'(
    (moveto 48 361.164)
    (lineto 48 210.75)
    (curveto 69 231.75 97.5 240.75 126.75 240.75)
    (curveto 213.75 240.75 267 202.5 267 120)
    (curveto 267 48.75 198 0 122.25 0)
    (curveto 60 0 0 31.5 0 87)
    (curveto 0 113.25 21.75 135 48 135)
    (curveto 74.25 135 96 113.25 96 87)
    (curveto 96 69 66.75 65.25 66.75 47.25)
    (curveto 66.75 24 95.25 19.5 122.25 19.5)
    (curveto 164.25 19.5 175.5 71.25 175.5 120)
    (curveto 175.5 165.75 166.5 216.75 126.75 216.75)
    (curveto 95.25 216.75 63.75 210 45.75 185.25)
    (curveto 43.5 181.5 39.75 180 36 180)
    (curveto 30 180 23.25 184.5 23.25 192)
    (lineto 23.25 361.5)
    (curveto 23.25 374.117 47.941 375.473 48 361.164)
    (closepath))
\translate #'(.22 . 1.58) \override #'(thickness . 2) \draw-line #'(1.6 . 0)

%% Some notations defined as markup/glyph combinations:

plusTwo = \markup \combine \elongatedTwo
\translate #'(1.35 . .35) \override #'(thickness . 1.8) \draw-line #'(0 . -.7)

dimTwo = \markup \combine \elongatedTwo
\translate #'(1.3 . -.8) \scale #'(.7 . .7) \flat

natTwo = \markup \combine \combine \elongatedTwo
\translate #'(1.34 . .35) \override #'(thickness . 1.4) \draw-line #'(0 . -1.75)
\translate #'(1.3 . -.9) \scale #'(.7 . .7) \natural

elongatedFour = \markup \combine
\scale #'(.8 . .8) \number 4
\translate #'(.08 . .48) \override #'(thickness . 1.8) \draw-line #'(2 . 0)

plusFour = \markup \combine \elongatedFour
\translate #'(1.7 . .84) \override #'(thickness . 1.8) \draw-line #'(0 . -.7)

dimFour = \markup \combine \elongatedFour
\translate #'(1.7 . -.4) \scale #'(.7 . .7) \flat

natFour = \markup \combine \combine \elongatedFour
\translate #'(1.73 . .84) \override #'(thickness . 1.4) \draw-line #'(0 . -1.75)
\translate #'(1.7 . -.4) \scale #'(.7 . .7) \natural

plusFive = \markup \combine \elongatedFive
\translate #'(1.45 . 1.94) \override #'(thickness . 1.8) \draw-line #'(0 . -.7)

dimFive = \markup \combine \elongatedFive
\translate #'(1.4 . .9) \scale #'(.6 . .6) \flat

natFive = \markup \combine \combine \elongatedFive
\translate #'(1.43 . 1.94) \override #'(thickness . 1.4) \draw-line #'(0 . -1.55)
\translate #'(1.4 . .8) \scale #'(.6 . .6) \natural

slashedSix = \markup \combine \openedSix
\translate #'(.5 . 1.6) \override #'(thickness . 1.2) \draw-line #'(.8 . -0.35)

elongatedSix = \markup \combine \openedSix
\translate #'(1.1 . 1.6) \override #'(thickness . .8) \draw-line #'(.6 . .13)

dimSix = \markup \combine \elongatedSix
\translate #'(1.4 . .9) \scale #'(.6 . .6) \flat

natSix = \markup \combine \combine \elongatedSix
\translate #'(1.42 . 2.1) \override #'(thickness . 1.4) \draw-line #'(0 . -1.6)
\translate #'(1.4 . .9) \scale #'(.6 . .6) \natural

slashedNine = \markup \rotate #180 \slashedSix

%% Formatter function:

#(define-public (vv-format-bass-figure figure event context)
   (let ((fig (ly:event-property event 'figure))
         (slash (eq? #t (ly:event-property event 'augmented-slash)))
         (aug (eq? #t (ly:event-property event 'augmented)))
         (alt (ly:event-property event 'alteration)))
     (cond
      (slash (case figure
               ((6) slashedSix)
               ((9) slashedNine)
               (else (format-bass-figure figure event context))))
      ; limitation: numbers that are both slashed _and_ augmented
      ; will be disregarded. (From a musical point of view,
      ; this shouldn’t be much of a problem.)
      ((and aug
            (eq? (ly:context-property context 'figuredBassPlusDirection)
                 RIGHT))
       (case figure
         ((2) plusTwo)
         ((4) plusFour)
         ((5) plusFive)
         (else (format-bass-figure figure event context))))
      ; This could be made optional.
      ((and (not (null? alt))
            (eq? (ly:context-property context 'figuredBassAlterationDirection) 
                 RIGHT))
       (cond
        ((= alt FLAT)
         (case figure
           ((2) dimTwo)
           ((4) dimFour)
           ((5) dimFive)
           ((6) dimSix)
           (else (format-bass-figure figure event context))))
        ((= alt NATURAL)
         (case figure
           ((2) natTwo)
           ((4) natFour)
           ((5) natFive)
           ((6) natSix)
           (else (format-bass-figure figure event context))))
        (else (format-bass-figure figure event context))))
      ; anything that is not explicitely being looked for
      ; will be handled by the default existing formatter.
      (else (format-bass-figure figure event context)))))

%% Inclusion of the new formatter:

\layout {
  \context {
    \Score
    figuredBassFormatter = #vv-format-bass-figure
  }
}

%% A simple example:

\figures {
  <6\\> <9\\>
  % Modified glyphs are used only when
  % plus signs are printed on the right.
  \set figuredBassPlusDirection = #RIGHT
  <2\+> <4\+> <5\+>
  \set figuredBassAlterationDirection = #RIGHT
  <2-> <4-> <5-> <6->
  <2!> <4!> <5!> <6!>
}


