\version "2.22.2"

\header {
  texidoc = "
In 20th century music, where time signatures tend to change a lot, it
is sometimes recommended to put the time signatures on top of the score
(or above each @code{StaffGroup} in the case of an orchestral score).
This can be achieved by creating a dummy staff which only contains the
@code{Time_signature_engraver}. In this specific example, a separate
identifier is used to define every time signature change, which saves
the bother of entering them again when typing the actual music (careful
though: it makes getting lost easier!).

Notice the overriding of the @code{X-offset} property: a specific trick
to make the time signatures align with the barlines, thanks to Han-Wen.


"
  doctitle = "Time Signatures on top of the score using a separate staff"
}
%% http://lsr.di.unimi.it/LSR/Item?id=272

\layout {
  \context {
    \type "Engraver_group"
    \consists "Time_signature_engraver"
    \consists "Axis_group_engraver"
    \name "TimeSig"
    \alias "Staff"
    \override TimeSignature.font-size = #3
    \override TimeSignature.break-align-symbol = ##f
    \override TimeSignature.X-offset =
      #ly:self-alignment-interface::x-aligned-on-self
    \override TimeSignature.self-alignment-X = #CENTER
    \override TimeSignature.after-line-breaking =
      #shift-right-at-line-begin
  }
  \context {
    \Score
    \accepts TimeSig
  }
  \context {
    \Staff
    \remove "Time_signature_engraver"
  }
}

timeSignatures = { \numericTimeSignature \time 2/4 s2 \time 3/4 s2. \time 4/4 s1 }

\score {
  <<
    \new TimeSig \timeSignatures
    \new Staff \relative c' { c'2 c2. c1 }
    \new Staff { a2 a2. a1 }
  >>
}



