\version "2.22.2"

\header {
  texidoc = "
If you temporarily have additional lyrics to a voice you can keep the
lyrics context alive with the following construct. Unless you do this,
a further temporary lyrics context would create a separate line (if it
happens on the same system of music).

The solution is to create one or more named lyrics context(s) with 


@code{\\new Lyrics = \"lyr1\"} @code{\\new Lyrics = \"lyr2\"} … 

before they are filled with the lyrics text.


It is noteable that the definition of the contexts must  use \\new …
while later references must  use \\context …








"
  doctitle = "Keeping a Lyrics context alive"
}
%% http://lsr.di.unimi.it/LSR/Item?id=781

\score {
  \new Staff <<
    \new Voice = "melody" {
      \relative c'' {
        a1 \repeat volta 2 {a} 
        b \repeat volta 2 {b}
    } }
    \context Lyrics ="line1" \with{ associatedVoice = "melody" } \lyricmode 
    {
      one 
      <<  % this is the 1st temporary lyric part
        \context Lyrics = "line1" { one }
        \context Lyrics = "line2" { two } 
        % the context "line2" dies here
      >>
      one 
      <<  % this is the 2nd temporary lyric part
        \context Lyrics = "line1" { one }
        \context Lyrics = "line2" { two }
      >>
    }
  >>
}



