\version "2.22.2"

\header {
  texidoc = "
If you have a set of parts to build a score, but they differ in the
@code{\\repeat volta} and @code{\\alternative} layout, it is a good
idea to display them parallel in one score, but still isolated.


This is achieved by moving a couple engravers from the @code{Score}
context to the @code{Staff} context.



"
  doctitle = "Compare and adjust parts with different volta settings to create a score"
}
%% http://lsr.di.unimi.it/LSR/Item?id=872

%by: ArnoldTheresius

%here starts the snippet:

\score {
  <<
    \new Staff {
      \tempo 4 = 96
      \repeat volta 2 { c''1 c'' b' }
      \alternative { { a'1 } { c'' } }
      \repeat volta 2 { d''1 \mark "A" f'' R1*2 }
      \tempo 4 = 108
      \repeat volta 2 { e''1 c''' b'' c''' }
    }
    \new Staff {
      \override Score.BarNumber.break-visibility = #end-of-line-invisible
      \set Score.alternativeNumberingStyle = #'numbers-with-letters
      \tempo 4 = 96
      \repeat volta 2 { g'1 a' g' g' }
      \repeat volta 2 { b'1 \mark "A" }
      \alternative { { b'1 g' g' } { e' e' f' } }
      \tempo 4 = 108
      \repeat volta 2 { a'1 fis'' f''? e'' }
    }
    \new Staff {
      \tempo 4 = 96
      \repeat volta 2 { e'1 f' f' e' }
      \repeat volta 2 { g'1 \mark "A" d' }
      \alternative { { d'1 d' } { c'1 d' } }
      \tempo 4 = 108
      \repeat volta 2 { cis'2 e' a'1 d''}
      \alternative { { a'1 } { g'1 } }
      \bar "|."
    }
    \new Staff {
      \tempo 4 = 96
      \repeat volta 2 { c'1 c' d' c' }
      \repeat volta 2 { g1 \mark "A" \repeat unfold 3 g1 }
      \tempo 4 = 108
      \repeat volta 2 { a1 d' g }
      \alternative { { a1 } { c'1 } }
      \bar "|."
    }
  >>
  \layout {
    \context {
      \Score
      \remove "Timing_translator"
      \remove "Volta_engraver"
      \remove "Mark_engraver"
      \remove "Mark_tracking_translator"
      \remove "Staff_collecting_engraver"
      \remove "Bar_engraver"
      % \remove "Time_signature_performer"   % optional
      % \remove "Control_track_performer"    % optional
      \remove "Tempo_performer"
      \remove "Repeat_acknowledge_engraver"
      \remove "Metronome_mark_engraver"
      % \remove "Parenthesis_engraver"       % optional
      \remove "Bar_number_engraver"
    }
    \context {
      \Staff
      \consists "Timing_translator"
      % \consists "Ambitus_engraver"          %% addition may be desired
      \consists "Volta_engraver"
      \consists "Mark_engraver"
      \consists "Mark_tracking_translator"
      \consists "Staff_collecting_engraver"
      \consists "Bar_engraver"                % mostly not required in Staff, but removed from Score
      % \consists "Time_signature_performer"  % optional
      % \consists "Control_track_performer"   % optional
      \consists "Tempo_performer"
      \consists "Repeat_acknowledge_engraver"
      \consists "Metronome_mark_engraver"
      % \consists "Parenthesis_engraver"      % optional
      \consists "Bar_number_engraver"
      % ... and how to show the bar numbers by default in each staff
      alternativeNumberingStyle = #'numbers-with-letters
      \override BarNumber.break-visibility = #all-visible
      \override BarNumber.color = #blue
    }
  }
}

\paper { tagline = ##f }

