\version "2.22.2"

\header {
  texidoc = "
In a simple time signature of 2/2 or 4/4, 8th notes are beamed by
default as two sets of four. Using a macro which overrides the
autobeaming behavior, this snippet changes the beaming to quarter note
beats. 



"
  doctitle = "Automatic beams two per two in 4/4 or 2/2 time signature"
}
%% http://lsr.di.unimi.it/LSR/Item?id=605


% Automatic beams two per two in 4/4 or 2/2 time signature
%              _____
% Default     | | | |
%              _   _
% Required    | | | |

% LSR: The good way adapted from David Bobroff

% macro for beamed two per two in 2/2 and 4/4 time signature
qBeam = {
        \set beamExceptions =
  	#'(                      
  	   (end .                
  	    (                    
  	     ((1 . 8) . (2 2 2 2))   
  	   )))
}

\score {
  <<
    \new Staff {
      \relative c'' {
        \time 4/4
        g8-"without the macro" g g g g g g g
        g8 g g g4 g8 g g
      }
    }
    %Use the macro
    \new Staff {
      \relative c'' {
        \time 4/4
        \qBeam 
        g8-"with the macro" g g g g g g g
        g8 g g g4 g8 g g
      }
    }
  >>
  \layout {
    \context {
      \Staff
      \numericTimeSignature
    }
  }
}



