\version "2.22.2"

\header {
  texidoc = "
If necessary you can resort to manually adjusting the control points of
a slur.  This example demonstrates the use of @code{\\vshape},
visualizing the control points as an aid to adjust the slur's shape. 
After the adjustment is done, simply replace @code{\\vshape} with
@code{\\shape}.


The @code{\\shape} command also supports shaping of slurs broken by a
line break, which is explained in LilyPond's Notation reference.


 Adjusting slurs with @code{\\shape} should be the last editing step;
there are high chances that layout changes also alter the shape of
slurs. 

"
  doctitle = "Setting the control points of a slur manually"
}
%% http://lsr.di.unimi.it/LSR/Item?id=134

\score {
  \new PianoStaff
  <<
    \context Staff = "up" {
      \clef bass
      s1 * 4
    } 
    \context Staff = "down" \relative c 
    <<
      s1*4
      {
        \clef bass
        r4 r8
        \vshape #'((-0.5 . -3) (10 . 2) (-25 . -20) (-0.5 . -6)) Slur
        c8( as' f c' as
        
        % line breaks will mess up this example  
        \noBreak
        f f,, as'' f
        \change Staff = up
        \clef treble
        c' as f' c
        \noBreak
        as' f c' as
        f' c as' f c'4)
      }
    >>
  >>
  \layout { }
}

