\version "2.22.2"

\header {
  texidoc = "
According to Elaine Gould, Behind Bars, chapter Repeated Sections, page
234, \"When there is a new clef, key signature or time signature at the
beginning of a repeated section\" the repeat marks should be printed
afterwards.

This is currently not the default in LilyPond.


This snippet provides a manual workaround. 

"
  doctitle = "Placing changes of clef, time signature and key signature at the beginning of a repeated section"
}
\markup\italic "Default output:"
{
  \clef F
  \key d\major
  \time 3/4
  \repeat volta 2 {
    R2.
  }
  \time 4/4
  \numericTimeSignature
  \repeat volta 2 {
    R1
  }
  \clef G
  \key e\minor
  \time 3/4
  \repeat volta 2 {
    R2.
  }
} 

\markup\italic "Following Elaine Gould:"
{
  \clef F
  \key d\major
  \time 3/4
  \repeat volta 2 {
    R2.
  }
  \once\override Staff.TimeSignature.space-alist.first-note = #'(fixed-space . 0)
  \time 4/4
  \numericTimeSignature
  \grace s1
  \bar ".|:-|"
  \repeat volta 2 {
    R1
  }
  \once\override Score.BreakAlignment.break-align-orders = 
          #(make-vector 3 
             '(staff-bar 
               clef 
               key-cancellation 
               key-signature 
               time-signature)) 
  \once\override Staff.BarLine.space-alist.clef = #'(extra-space . .7)
  \once\override Staff.Clef.space-alist.key-cancellation = #'(minimum-space . 3)
  \once\override Staff.Clef.space-alist.key-signature = #'(minimum-space . 3)
  \clef G
  \key e\minor
  \time 3/4
  \grace s1
  \bar ".|:-|"
  \repeat volta 2 {
    R2.
  }
}

\paper { tagline = ##f }


