\version "2.22.2"

\header {
  texidoc = "
Under Notation Reference > Staff notation > Modifying single staves
(section 1.6.2) > Ossia staves, one technique is given in which a
separate staff is created for the ossia, and @code{\\context
Staff=\"ossia\"} places notes on the ossia staff.


The technique recommends removing the time signature engraver and
making clefs transparent. If there is a key signature, then the
\"Key_engraver\" may also need to be removed.



  \\remove \"Time_signature_engraver\"
  \\override Clef #'transparent = ##t


Problem: If there is a meter, clef, or key change in the middle of an
ossia passage, those will be invisible.


Solution: Instead of removing the engravers, override the relevant
stencils to be @code{#f}, hiding them where they are not needed. Then
it's easy to @code{\\once \\revert} the stencil(s) where needed.


In this example, the change to 3/4 time appears in the ossia staff at
the end of the first system, and both the clef and meter appear at the
beginning of the second system (whereas they are hidden at the start of
the first system). 

"
  doctitle = "Ossia staves with clefs and time signatures"
}
%% http://lsr.di.unimi.it/LSR/Item?id=774

%here starts the snippet:

%LSR modified by P.P.Schneider on Feb.2014

\include "english.ly"

showMeter = { \once \revert Staff.TimeSignature.stencil }

outline = {
  \time 4/4 s1*2
  \showMeter \time 3/4 s2.
  \showMeter \time 4/4 s1*2
}

\score {
  <<
    \new Staff = "ossia" \with {
      \override Clef.stencil = ##f
      \override KeySignature.stencil = ##f
      \override TimeSignature.stencil = ##f
      fontSize = #-3
      \override StaffSymbol.staff-space = #(magstep -3)
      \override StaffSymbol.thickness = #(magstep -3)
    } {
      \stopStaff
      \outline
    }
    \new Staff <<
      \outline
      {
	\repeat unfold 16 { b'16 }
	<<
	  { \repeat unfold 60 { b'16 } }
	  \context Staff="ossia" {
	    \revert Staff.Clef.stencil
	    \startStaff
	    \repeat unfold 22 { b'8 }
	    \override Clef.stencil = ##f
	    \stopStaff
	  }
	>>
      }
    >>
  >>
}

\paper { tagline = ##f }


