\version "2.22.2"

\header {
  texidoc = "
LilyPond supports a number of pre-defined clefs, all of which show the
clef symbol on some staff line. If you need the clef symbol between two
lines, say, you can either manually set @code{Staff.clefGlyph},
@code{Staff.clefPosition}, and @code{Staff.middleCPosition} to the
appropriate values, or you can add your own clef definition so that you
can use @code{\\clef myCustomClef}, for example. This can be achieved
by using the @code{add-new-clef} function which has the form:


@code{(add-new-clef \"myCustomClef\" \"clefs.GLYPH\" clef-position
octavation c0-position)}


The parameters are as follows.


@code{\"myCustomClef\"} is the name of the new clef.


@code{\"clefs.GLYPH\"} describes the actual clef glyph (e.g.,
\"clefs.g\" for the treble clef, \"clefs.neomensural.c\" for the
neomensural c glyph, etc.).


@code{clef-position} determines the position of the clef, counted from
the center line of the staff. For example, a value of 1 means the clef
is shown between the center line and the line above, 4 means the clef
is shown on the top line, -2 means it is shown on the second line of
the staff.


@code{octavation} describes the octave transposition, which is
typically 0.


@code{c0-position} determines the position of middle C on the staff
relative to @code{clef-position}. For example, a value of -2 means
middle C will be two staff positions (lines or spaces) below
@code{clef-position}. 

"
  doctitle = "Using non-standard clef positions and adding customized clef definitions"
}
%% http://lsr.di.unimi.it/LSR/Item?id=401
%% Upgraded by Paul Morris on Nov 11, 2013, see : http://lilypond.1069038.n5.nabble.com/Snippet-Using-non-standard-clef-positions-and-adding-customized-clef-definitions-td153775.html

% \header { title = "Non-standard clefs added manually and as a new definition" }

% manually setting all clef properties is one possibility:

myclef = {
  \set Staff.clefGlyph = #"clefs.neomensural.c"
  \set Staff.clefPosition = #1
  \set Staff.middleCPosition = #1 
}

% defining your own clef is another possibility. 
% You can then use \clef myCustomClef 

% Add a new clef called "myCustomClef", which describes a neomensural 
% C-clef shown between the third (center) and the fourth staff line. 
% Neither octavation nor adjustment of the position of middle C 
% relative to the clef (c0-position) is needed, so these arguments are 0.

% add-new-clef arguments: clef-name clef-glyph clef-position octavation c0-position

#(add-new-clef "myCustomClef" "clefs.neomensural.c" 1 0 0)

<<
  \context Staff = "Manual" \with { instrumentName = "Manual settings" } <<
    \myclef
    \relative c' { c4 c c c }
  >>
  \context Staff = "ClefDef" \with { instrumentName = "Clef definition" } <<
    \clef myCustomClef
    \relative c' { c4 c c c }
  >>
>>

\paper { tagline = ##f }

% As of 11-11-2013 "add-new-clef" is defined in "parser-clef.scm" in LilyPond's source code.





