\version "2.22.2"

\header {
  texidoc = "
Held note or tenuto fingering indicates that a finger should be kept
pressed on the fret also after the actual duration of the note. This is
usually suggested to facilitate the move of the fingers to the next
position. It is represented by a digit (the finger) followed by a t
(meaning tenuto).


If you use @code{\\finger \"3t\"}, you will get a poor result, because
\\finger uses the Emmentaler notation font, which has numbers but not
letters. As a result, the number will use a serif font, while the
letter t will use a san serif font. The letter t will also be
positioned incorrectly.


This snippet contains a function which creates the desired fingering
object without above problems. 

"
  doctitle = "Held note (tenuto) fingering"
}
% http://lists.gnu.org/archive/html/lilypond-user/2018-05/msg00099.html

tenutoFingeringMark = \markup \text \fontsize #2 \bold "t"
t = #(define-event-function (n) (index?)
  #{ \finger \markup \concat { #(format #f "~d" n) \tenutoFingeringMark } #})

{
  c'4\t3 e'_\t1 a'2-\t2
}


