\version "2.22.2"

\header {
  texidoc = "
When using @code{\\partCombine}, commands applying to a @code{Voice}
context affect both parts since when are merged in the same Voice. This
snippet defines a music function to apply tweaks to all elements of a
certain kind in a music expression. This can be used to apply
modifications to all grobs caused by elements of a music expression
regardless of the context structure. Possible values for the
@code{event-class} argument are listed at the Internals Reference

"
  doctitle = "Applying tweaks to one voice in \\partCombine"
}
%% Original thread: https://lists.gnu.org/archive/html/lilypond-user/2021-06/msg00242.html

\paper { tagline = ##f }

tweakEverywhere =
#(define-music-function (parser location event-class property value music)
                        (symbol? symbol-list-or-symbol? scheme? ly:music?)
     (for-some-music
        (lambda (m)
           (if (music-is-of-type? m event-class)
                 (begin
                    (set! (ly:music-property m 'tweaks)
                             (cons (cons
                                     (if (symbol? property)
                                         property
                                         (apply cons* property))
                                     value)
                                   (ly:music-property m 'tweaks)))
                    #t)
                 #f))
        music)
     music)

soprano = { des' ees' fes' ges' fes' ges' aes' bes' }
tenor = { des' ees' fes' ges' des' ees' fes' ges' }

% Replace with \partCombineUp (uppercase C) in version 2.20 and later.
\partCombineUp \soprano \tweakEverywhere rhythmic-event font-size -3 \tenor
\partCombineUp \soprano \tweakEverywhere note-event Accidental.color #red \tenor



