\version "2.22.2"

\header {
  texidoc = "
Create a compound time signature for irregular meters.


Function @code{\\irregularMeter} accepts the same arguments as function
@code{\\compoundMeter}; it also produces the same visual appearance of
the time signature elements.  However, it doesn't insert a plus sign
between the (top-level) elements but rather a small horizontal space. 
Additionally, it doesn't change the timing, which means that it is
still necessary to insert proper @code{\\time} commands, to say
@code{\\omit Timing.TimeSignature} before the first @code{\\time}
command in the section with irregular meters, and @code{\\undo \\omit
Timing.TimeSignature} after this section.



"
  doctitle = "Setting multiple time signatures at the start of a bar"
}
irregularMeter =
#(define-music-function (args) (pair?)
  #{
    \once \override Timing.TimeSignature.stencil =
      #(lambda (grob)
         (grob-interpret-markup
          grob
          (make-concat-markup
            (list-join
              (map make-compound-meter-markup args)
              (make-hspace-markup 0.3)))))
  #})


\relative c'' {
  \key g \major
  \irregularMeter #'((2 4) (3 4) 4)

  \partial 4 d8 c |
  \omit Timing.TimeSignature
  \time 2/4 b4 d |
  \time 3/4 e8 d c b a g |
  \time 4/4 r2. c8 b
  \time 2/4 a4 c |
  \time 3/4 d8 c b a g fis |
  \undo \omit Timing.TimeSignature
  \time 3/4 g4 b a8 a |
  g2 \bar "|."
}

