\version "2.22.2"

\header {
  texidoc = "
 @code{\\globalizeMusic} is a possible solution for the problem you get
when you put all your @code{\\repeat volta} structures in a separate
music variable (named generally @code{ \\global }) and then you want to
unfold all your music (for MIDI output for example). Suppose you have
defined the following :

@code{
   global = @{ s1 \\repeat volta 2 @{ s1@} \\alternative @{@{s1@} @{s1@}
@}@} 
   musicA = \\relative @{ c1 d e f g@}
   musicB = \\relative @{ \\clef bass c,1 d e f g@} } Then, the function
@code{\\globalizeMusic} can be used like this : @code{
   \\globalizeMusic
      \\new StaffGroup
           @{<<
                \\new Staff  \\musicA
                \\new Staff  \\musicB
           >>@} } It will have the same effects than @code{
    \\new StaffGroup
          @{<<
                \\new Staff  >
                \\new Staff  >
          >>@} } BUT all the @code{\\repeat volta} structures will be copied
inside each Staff, so that you will get the correct unfolded music when
you call @code{\\unfoldRepeats}.  (not true using the traditionnal
@code{>} structure ). The pdf here shows the behaviour of the function.

To use @code{\\globalizeMusic}, you have to download 2 files :
globalizeMusic.ly and  also extractMusic.ly (because globalizeMusic.ly
uses extractMusic.ly internally). You can find extractMusic.ly here and
globalizeMusic.ly here These 2 files should be put in the same
directory.



"
  doctitle = "Making \\unfoldRepeats work with \\repeat volta structure"
}
%% http://lsr.di.unimi.it/LSR/Item?id=767


global = { s1 \repeat volta 2 { s1} \alternative {{s1} {s1} }} 
musicA = \relative c' { c1 d e f g}
musicB = \relative c' { \clef bass c,1 d e f g}

oldWayScore = \new StaffGroup  <<
    \new Staff <<\musicA \global>>
    \new Staff <<\musicB \global>>
  >>

\score { \oldWayScore }
\score { \unfoldRepeats \oldWayScore }



