\version "2.22.2"

\header {
  texidoc = "
The purpose of the \\elseTag command is to make the use of tagged music
easier.

This exemple shows the same music, without and with \\elseTag. In the
old manner (first exemple), you have to write all the tag names you
want,and to omit only the one you don't want. In the second exemple,
\\elseTag exclude automatically the tag you don't want, and keep all
the others.


\\elseTag has the same syntaxe than \\tag and has to be use in
conjonction with \\keepWithTag. 

"
  doctitle = "Using a custom \\elseTag command to replace several \\tag commands"
}
%% http://lsr.di.unimi.it/LSR/Item?id=381

% improbable name ...
elseTagName = #(gensym)

%% elseTag defines two symbols for property 'tags of the music
elseTag =
#(define-music-function (tag arg)(symbol? ly:music?)
   (set! (ly:music-property arg 'tags)
         (cons tag (cons elseTagName (ly:music-property arg 'tags))))
   arg)

%% this redefinition of keepWithTag verifies that the music has NOT at the same
%% time the symbol "tag" and "elseTagName" (above) in its 'tags property
keepWithTag =
#(define-music-function (tag music) (symbol? ly:music?)
   (music-filter
    (lambda (m)
      (let* ((tags (ly:music-property m 'tags))
             (resA (memq tag tags))
             (resB (memq elseTagName tags)))
        (or (eq? tags '())
            (and (not (equal? resA #f))
                 (equal? resB #f))
            (and (not (equal? resB #f))
                 (equal? resA #f)))))
    music))
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

musicOld = \new Staff \relative c' {
  \tag #'any s1*0^\markup "Only with tag"
  \tag #'partD { c1 ~ c ~ c }
  \tag #'any \tag #'partA \tag #'partB \tag #'partC {
    c4 d e
    \tag #'partC { g4 ~ g1 ~ g }
    \tag #'any \tag #'partA \tag #'partB {
      g4 c
      \tag #'partB { d2. ~ d1 }
      \tag #'any \tag #'partA {
        d4
        \tag #'partA { e2 ~ e1 }
        \tag #'any { e4 g c1 }
      }
    }
  }
}

music = \new Staff \relative c' {
  \tag #'any s1*0^\markup "With elseTag"
  \tag #'partD { c1 ~ c ~ c }
  \elseTag #'partD {
    c4 d e
    \tag #'partC { g4 ~ g1 ~g }
    \elseTag #'partC {
      g4 c
      \tag #'partB { d2. ~d1 }
      \elseTag #'partB {
        d4
        \tag #'partA { e2 ~ e1 }
        \elseTag #'partA { e4 g c1 }
      }
    }
  }
}

<<
  \new StaffGroup <<
    \keepWithTag #'any \musicOld
    \keepWithTag #'partA \musicOld
    \keepWithTag #'partB \musicOld
    \keepWithTag #'partC \musicOld
    \keepWithTag #'partD \musicOld
  >>
  \new StaffGroup <<
    \keepWithTag #'any \music
    \keepWithTag #'partA \music
    \keepWithTag #'partB \music
    \keepWithTag #'partC \music
    \keepWithTag #'partD \music
  >>
>>






