\version "2.22.2"

\header {
  texidoc = "
In piano music, you may occasionally come across a staff in which a
held (pedal) note is followed by a clef change and further polyphonic
notation.


With a little bit of work involving clef settings, you can overcome
this problematic situation.


In the first figure, we can see that a clef change in one voice messes
with the pedal note in a lower voice; the tie appears to have changed
voices.


You can create a @qq{fake} treble clef which has the properties of a
bass clef by overriding the following properties:


@code{\\set Staff.clefGlyph = #\"clefs.G\"} - show a G clef


@code{\\set Staff.clefPosition = #-2} - set the staff position two half
spaces below centre line (i.e., on G)


@code{\\set Staff.middleCPosition = #6} - set middle C to the same
position as a bass clef


The second figure shows the solution as applied to the final bar of a
Wolf lied. The pedal note E flat is followed by a treble clef and a
high octave E flat. Since we are effectively still in the bass clef, we
have to input the octave E flat as an octave G to produce the required
output. Using @code{\\tag} splits the musical layout and MIDI so you
can use @code{\\keepWithTag #'midi} in a MIDI @code{\\score} block.


The third figure shows a more extended example from Debussy's L'Isle
joyeuse in which the bass clef is faked.


Finally, the fourth figure shows the same Debussy excerpt with an
additional feature you may encounter: the pedal note is preceded by a
small cautionary clef printed after the barline.



"
  doctitle = "Combining pedal notes with clef changes"
}
%% http://lsr.di.unimi.it/LSR/Item?id=326

% Treble clef with properties of bass clef
fakeTrebleClef = {
  \set Staff.clefGlyph = #"clefs.G"
  \set Staff.clefPosition = #-2
  \set Staff.middleCPosition = #6
}

% Bass clef with properties of treble clef
fakeBassClef = {
  \set Staff.clefGlyph = #"clefs.F"
  \set Staff.clefPosition = #2
  \set Staff.middleCPosition = #-6
}

% Similar to above, but lower and positioned after barline
fakeBassClefShift = {
  % Change default prefatory item order so that clef is printed after barline
  \override Score.BreakAlignment.break-align-orders =
    #(make-vector 3 '(span-bar
                      breathing-sign
                      staff-bar
                      clef
                      key
                      time-signature))
  \set Staff.clefGlyph = #"clefs.F"
  \set Staff.clefPosition = #-8
  \set Staff.middleCPosition = #-6
}

\markup {
  1. Without tweaking clef properties, output is nonsensical }
\score {
  \new Staff \relative c {
    \clef bass \voiceTwo
    c2 ~
    <<
      { c | }
      \new Voice \relative c'' {
        \clef treble \voiceOne
        c8 c g' g |
      }
    >>
  }
}

\markup {
  2. Final bar of
  \italic "Gesegnet sei, durch den die Welt entstund..."
  from Wolf's \italic "Italienisches Liederbuch" }
\score {
  \new PianoStaff <<
    \new Staff \relative c' {
      \key es \major
      \override DynamicLineSpanner.padding = #2.5
      <bes es g>8\ppp <bes es g>
      <bes es g>[ <bes es g>] ~ <bes es g>2\fermata \bar "||"
    }
    \new Staff \relative c \keepWithTag #'layout {
      \clef bass \key es \major
      r8. \stemDown <es es,>16 <es es,>4 ~
      <<
        { \voiceTwo <es es,>2 }
        \new Voice {
          % The faked clef and notes
          \voiceOne \tag #'layout { \fakeTrebleClef <g g'>\fermata }
          % The real notes for MIDI output
          \tag #'midi { <es'' es'> }
        }
      >> \bar "|."
    }
  >>
}

\markup {
  3. Bars 148 - 151 from Debussy's \italic "L'Isle joyeuse" }
\score {
  \new PianoStaff <<
    \new Staff \relative c' {
      \time 3/8
      \set subdivideBeams = ##t
      \override TupletNumber.stencil = ##f
      \override TupletBracket.stencil = ##f
      \tieDotted
      <<
        {
          \voiceOne
          \tuplet 3/2 {
            fis16( e d \repeat unfold 5 { c d e fis e d } c d e) }
        }
        \new Voice {
          \voiceTwo
          bes4. ~ |
          bes |
          bes ~ |
          bes |
        }
      >>

      <>^\markup {
          4. As above, but with small clefs on pedal notes }
      <<
        {
          \tuplet 3/2 {
            fis'16( e d \repeat unfold 5 { c d e fis e d } c d e) }
        }
        \new Voice {
          \voiceTwo
          bes4. ~ |
          bes |
          bes ~ |
          bes |
        }
      >>
    }

    \new Staff \relative c'' \keepWithTag #'layout {
      \time 3/8
      <<
        {
          \voiceOne
          bes8\rest \clef treble as16( c as8)
          as16( c as8) as16( c)
          bes( d bes8. d16)
          bes8.( d16 bes8)
        }
        \new Voice {
          \voiceTwo
          \tag #'layout {
            \fakeBassClef
            a,4. ~ |
            a ~ |
            a ~ |
            a |
          }
          \tag #'midi {
            c,, ~ |
            c ~ |
            c ~ |
            c |
          }
        }
      >>
      % Make clefs visible for each bar, except at end of system
      \override Staff.Clef.break-visibility = #end-of-line-invisible
      <<
        {
          \voiceOne
          bes'8\rest \clef treble as16( c as8)
          as16( c as8) as16( c)
          bes( d bes8. d16)
          bes8.( d16 bes8)
        }
        \new Voice {
          \voiceTwo
          \tag #'layout {
            \fakeBassClef
            a,4. ~ |
            % Shrink clef to small size
            \override Staff.Clef.font-size = #-5
            % We want to prevent clef size changing,
            % otherwise first clef is smaller
            \override Staff.Clef.full-size-change = ##t
            % The faked bass clef, printed after the barline and next
            % to the pedal note
            \fakeBassClefShift
            a ~ |
            % Because we have overridden break-visibility,
            % the cautionary clef is also displayed here...
            a ~ |
            % ...and here
            a |
            % Return to default clef properties
            \revert Score.BreakAlignment.break-align-orders
            \revert Staff.Clef.font-size
            \revert Staff.Clef.full-size-change
          }
          \tag #'midi {
            c,, ~ |
            c ~ |
            c ~ |
            c |
          }
        }
      >>
    }
  >>

  \layout {
    \context {
      \Score
      \remove "Bar_number_engraver"
    }
  }
}

\paper {
  indent = 0
  tagline = ##f
}

