\version "2.22.2"

\header {
  texidoc = "
Sometimes a note is to be played only in special circumstances (e.g.,
only on the first repeat).  One can use \\parenthesize to put
parentheses around the notehead. However, a different notation uses
square brackets. This snippet shows how to tweak the settings for
\\parenthesize to use square brackets instead of parentheses. A
function \\bracketify is defined, which works similar to parenthesize.

"
  doctitle = "Using brackets instead of parentheses for \\parenthesize"
}
%% http://lsr.di.unimi.it/LSR/Item?id=564

#(define-public (bracket-stencils grob)
  (let ((lp (grob-interpret-markup grob (markup #:fontsize 3.5 #:translate (cons -0.3 -0.5) "[")))
        (rp (grob-interpret-markup grob (markup #:fontsize 3.5 #:translate (cons -0.3 -0.5) "]"))))
    (list lp rp)))

bracketify = #(define-music-function (arg) (ly:music?)
   (_i "Tag @var{arg} to be parenthesized.")
#{
  \tweak Parentheses.stencils #bracket-stencils
    \parenthesize $arg
#})

\relative c'' {
  \bracketify c4
  \bracketify g4
  <e \bracketify g b>
  \bracketify <e g b>4
  \bracketify r4
}



