\version "2.22.2"

\header {
  texidoc = "
The following example demonstrates how to print individual staves with
a colored background.

"
  doctitle = "Coloring staves"
}
%% http://lsr.di.unimi.it/LSR/Item?id=726

%% LSR contributed by Valentin:
%% http://lists.gnu.org/archive/html/lilypond-user-fr/2010-10/msg00252.html

bgcolor =
#(define-music-function (color) (string?)
  #{
     \override Staff.StaffSymbol.stencil =
       #(grob-transformer 'stencil
          (lambda (grob orig)
             (let* ((X-ext (ly:stencil-extent orig X))
                    (Y-ext (ly:stencil-extent orig Y)))
               (set! Y-ext (cons
                  (- (car Y-ext) 2)
                  (+ (cdr Y-ext) 2)))
               (ly:grob-set-property! grob 'layer -10)
               (ly:stencil-add
                 (stencil-with-color
                   (ly:round-filled-box X-ext Y-ext 0)
                   (eval-string color))
                 orig))))
  #})

<<
  \new Staff { \bgcolor "blue" a'1 } % basic colors
  \new Staff { \bgcolor "(x11-color 'red)" b' } % x11 colors
  \new Staff { \bgcolor "(rgb-color 1 0.8 0.6)" c'' } % rgb colors
>>

