\version "2.22.2"

\header {
  texidoc = "
For analysis purposes, it could be helpful to put a colored background
behind some notes. 

"
  doctitle = "Colored background"
}
% http://lsr.di.unimi.it/LSR/Item?u=1&id=960

colorSpan =
#(define-music-function (y-lower y-upper color) 
     (number? number? color?)
    #{
      \once\override HorizontalBracket.stencil =
        #(grob-transformer 'stencil
          (lambda (grob orig)
            (let* ((X-ext (ly:stencil-extent orig X))
                   (Y-ext (cons y-lower y-upper)))
              (stencil-with-color (ly:round-filled-box X-ext Y-ext 0) color))))
      \once\override HorizontalBracket.layer = #-10
      \once\override HorizontalBracket.outside-staff-priority = ##f
      \once\override HorizontalBracket.Y-offset = #0
      \once\override HorizontalBracket.shorten-pair = #'(-.95 . -1.65)
    #})

\score {
  { 
    R1
    <<
      {
        \colorSpan #-5 #5 #(rgb-color 1.0 0.9 0.5) 
        c'2\startGroup g' c'\stopGroup
      }
      \\
      {
        \override ClusterSpanner.color = #(rgb-color 0.5 0.6 1)
        \override ClusterSpanner.layer = #-1
        \makeClusters { c'2 g' c' }
      }
    >>
    \colorSpan #-2 #2 #(rgb-color 0.5 1.0 0.5) 
    r4\startGroup r \stopGroup   
    
    \colorSpan #-2 #0 #red 
    r\startGroup s s r\stopGroup 
  }
  \layout {
    \context {
      \Voice
      \consists "Horizontal_bracket_engraver"
    }
  }
}




