\version "2.22.2"

\header {
  texidoc = "
If you wish to typeset @code{|.}, etc, style spanbars on a ChoirStaff,
you can add the span_bar_engraver, and instruct it to omit the
@code{|}-style bars. In this example a new context, SemiChoirStaff, is
created to achieve this.

"
  doctitle = "SemiChoirStaff is a ChoirStaff with SpanBars except \"|\"-type bars"
}
%% http://lsr.di.unimi.it/LSR/Item?id=299

mus = {
  \clef F
  c4 d e f | c d e f \bar "||"
  c4 d e f | c d e f \bar "|."
}

\layout {
  \context {
    \ChoirStaff
    \name "SemiChoirStaff"
    \consists "Span_bar_engraver"
    \override SpanBar.stencil =
      #(lambda (grob) 
        (if (string=? (ly:grob-property grob 'glyph-name) "|")
            (set! (ly:grob-property grob 'glyph-name) ""))
        (ly:span-bar::print grob))
  }
  \context {
    \Score
    \accepts SemiChoirStaff
  }
}

\score {
  \new SemiChoirStaff {
    <<
      \new Staff \mus
      \new Staff \mus
    >>
  }
}



