\version "2.22.2"

\header {
  texidoc = "
A common practice in lead sheets is to abbreviate chord changes when
only the bass note is changed. s, @code{Cmaj7, Cmaj7/B} would be
written as @code{Cmaj7, /B}, for example. There is no simple way to do
this in LilyPond, but it is possible to use a whiteout hack like
snippet #309 to accomplish the desired effect. 

"
  doctitle = "Abbreviating bass note changes"
}
%% http://lsr.di.unimi.it/LSR/Item?id=776

% Maybe I'll write a Scheme function for this, when I learn how...

slashBMusic = {
  <c e g>1-\markup { \hspace #-2 \whiteout "/B" }
}
slashB = #(sequential-music-to-chord-exceptions slashBMusic #t)

slashAMusic = {
  <c e g>1-\markup { \hspace #-2 \whiteout "/A" }
}
slashA = #(sequential-music-to-chord-exceptions slashAMusic #t)

\score { <<
  \new ChordNames \chordmode {
    c1:maj7 |
    \set chordNameExceptions = #slashB c |
    \set chordNameExceptions = #slashA c |
  }
  \new Staff \relative c'' {
    c4 c c c | c c c c | c c c c |
  }
>> }


