\version "2.22.2"

\header {
  texidoc = "
Sometimes the arrow-heads for directed arpeggios seem to be rather
small. The function @code{biggerArrow} provides a convenient method to
resize them. Limitation: if the scaling-factor exceeds 2, the result is
poor. Likely a rather rare case.

"
  doctitle = "Resize arrow-heads for directed arpeggio"
}
biggerArrow =
#(define-music-function (scale)(number?)
"Returns an override for @code{Arpeggio.stencil}, with arrow-heads scaled by 
@var{scale}"
#{
  \override Arpeggio.stencil =
  #(lambda (grob)
    (let* ((arp-dir (ly:grob-property grob 'arpeggio-direction)))
      ;; If 'arpeggio-direction is unset use default-stencil
      (if (null? arp-dir)
          (ly:arpeggio::print grob)
          (let* ((arrow-glyph
                   (format #f
                     "scripts.arpeggio.arrow.~a1"
                     (if (negative? arp-dir) "M" "")))
                 (font (ly:grob-default-font grob))
                 (arrow-head-stil (ly:font-get-glyph font arrow-glyph))
                 (arrow (ly:stencil-scale arrow-head-stil scale scale))
                 (arrow-y-ext (ly:stencil-extent arrow Y))
                 (arrow-x-ext (ly:stencil-extent arrow X))
                 (arrow-width (interval-length arrow-x-ext))
                 (pos (ly:grob-property grob 'positions)))
      
            ;; 'positions modified to reflect the height of the arrow-head
            (ly:grob-set-property! grob 'positions
              (if (positive? arp-dir)
                  (cons (car pos) (- (cdr pos) arrow-width))
                  (cons (+ (car pos) arrow-width) (cdr pos))))
                  
            ;; unset 'arpeggio-direction to get the default trill-line stencil
            (ly:grob-set-property! grob 'arpeggio-direction '())
      
            (let* ((stil (ly:arpeggio::print grob))
                   (stil-y-ext (ly:stencil-extent stil Y))
                   (stil-x-ext (ly:stencil-extent stil X))
                   (stil-width (interval-length stil-x-ext))
                   ;; A scaled arrow-head will be slightly off, find the value
                   ;; to compensate for x-axis, before adding it to the
                   ;; arpeggio-line
                   (scale-compensate-x (/ (- stil-width arrow-width) 2))
                   (new-stil
                     (ly:stencil-add
                       (ly:stencil-translate
                         arrow
                         (cons
                           scale-compensate-x
                           (if (negative? arp-dir)
                               ;; For a down pointing arrow, it's top will be at 
                               ;; arpeggio-line-bottom, move by it's height to   
                               ;; let the arrow-basis match with the line-bottom
                               (- (car stil-y-ext) 
                                  (interval-length arrow-y-ext))
                               (cdr stil-y-ext))))
                       stil)))

               ;; We need to adjust 'X-extent to reflect the enlarged arrow,
               ;; in order to avoid spacing issues
               (ly:grob-set-property! grob 'X-extent
                 (interval-widen 
                   (ly:arpeggio::width grob) 
                   (* scale-compensate-x -2)))
               
               ;; Do we need to resize the stencil? For now commented
               ;(ly:make-stencil
               ;  (ly:stencil-expr new-stil)
               ;  (interval-widen stil-x-ext (* scale-compensate-x -2))
               ;  (ly:stencil-extent new-stil Y))
               new-stil
               )))))
#})



{
  \markLengthOn
  \override Score.RehearsalMark.self-alignment-X = #LEFT
  \mark "default arrow-heads"
  \arpeggioArrowUp 
  <c' e' g' c''>4\arpeggio

  \arpeggioArrowDown
  q\arpeggio
  
  \arpeggioNormal
  q2\arpeggio

  \mark "enlarged arrow-heads"
  \arpeggioArrowUp 
  \biggerArrow 2
  q4\arpeggio

  \arpeggioArrowDown 
  \biggerArrow 2
  q\arpeggio
  
  \arpeggioNormal 
  %% biggerArrow returns default arpeggio for undirected Arpeggio
  \biggerArrow 2
  q2\arpeggio
}


