\version "2.22.2"

\header {
  texidoc = "
Sometimes for short polyphonic pieces – and to make the source more
readable –, it can be helpful to use @code{\\parallelMusic}.


Troubles come with repeats that should be entered as


\\parallelMusic #'(voiceA voiceB) @{
  \\repeat volta 2 @{ mes.1 mes.2 ... mes.n @} |
  \\repeat volta 2 @{ mes.1 mes.2 ... mes.n @} | @}

so the code becomes less readable and the use of @code{\\parallelMusic}
less understandable.


This snippet is a workaround that shows another way to write repeats in
@code{\\parallelMusic} mode by simply adding a bar at the end of the
score.


It also handles the wanted repeats in the midi output.



"
  doctitle = "Repeats with parallelMusic"
}
%% http://lsr.di.unimi.it/LSR/Item?id=924
% => http://lilypond.1069038.n5.nabble.com/snippet-Repeats-with-parallelMusic-td163832.html
% => http://lilypond.1069038.n5.nabble.com/parallelMusic-and-repeat-td27560.html

% by P.P.Schneider on June 2014.

%here starts the snippet:

\parallelMusic #'(voiceA voiceB) {
  \time 3/4
  \key a\minor
  \clef "G_8"
  \repeat volta 2 {
    % Bar 1
      a4 e'2 		|
      a,2. 		|
    % Bar 2
      d'8 c' b c' a4 	|
      a,2. 		|
    % Bar 3
      b8 gis e gis e' b |
      e,2 c4 		|
    % Bar 4
      d'8 c' b c' a4 	|
      a,2. 		|
    % Bar 5
      f'8 e' d' c' b a 	|
      d2. 		|
    % Bar 6
      gis2. 		|
      e4 e d 		|
    % Bar 7	
      e'4 d' c' 	|
      c2. 		|
    % Bar 8
      b2. 		|
      e4 e2 		|
  }
  \repeat volta 2 {
    % Bar 9
      e'4 a' e' 	|
      c2. 		|
    % Bar 10
      f'8 e' f' e' d'4 	|
      d2. 		|
    % Bar 11
      d'4 g' d' 	|
      b,2. 		|
    % Bar 12
      e'8 d' e' d' c'4 	|
      c2. 		|
    % Bar 13
      f'8 e' d' c' b a 	|
      d2. 		|
    % Bar 14
      gis2. 		|
      e4 e8 d c b, 	|
    % Bar 15
      c8 e' d' c' b c' 	|
      c4 d e 		|
    % Bar 16
      a2. 		|
      a,4 a,2 		|
  }
  \mark\markup\small\italic "D.C."
  % here's the hacky trick :
  |
}

\score {
  \new Staff 
  \with { instrumentName = Guitar }
  << \voiceA \\ \voiceB >>
}

\score {
  \new Staff {
    \unfoldRepeats << \voiceA \\ \voiceB >>
    << \voiceA \\ \voiceB >>
  }
  \midi {
    \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 128/4)
    }
  }
}

\paper { tagline = ##f }

