\version "2.22.2"

\header {
  texidoc = "
If you have multiple pieces (e.g., Kyrie, Gloria, Credo, etc. in
masses) in a large work, you can use multiple <code>\\score</code>
parts and use the piece header field to supply a title for each of the
pieces. However, the font is very small. You can either directly put
the markup into the <code>piece=...</code> header field, or better
re-define the <code>scoreTitleMarkup</code> function in the
<code>\\paper</code> section.

"
  doctitle = "Modifying default font properties for piece titles"
}
%% http://lsr.di.unimi.it/LSR/Item?id=306

%LSR modified/updated by P.P.Schneider on Feb. 2014

%here starts the snippet:

\header {
  title = "Formatting of piece headers"
}

\paper {
  scoreTitleMarkup = \markup { 
    \column {
      \if \should-print-all-headers { \bookTitleMarkup \hspace #1 }
      \fill-line {
        \fontsize #3 \bold \fromproperty #'header:piece
        \fromproperty #'header:opus
      }
    }
  }
  tagline = ##f
}

\markuplist { 
  \vspace #1
  \fill-line { 
    \justify-string # "If you have multiple pieces in a large work, 
        you can use multiple score parts and use the piece header 
        field to supply a title for each of the pieces. However, 
        the font is very small. You can either directly put the 
        markup into the piece=... header field, or better re-define 
        the scoreTitleMarkup function in the paper section."
  } 
  \vspace #1
}

\score { 
  \context Staff << { c'1 | R1 } >>
  \header{ piece="Piece 1" }
}

\score { 
  \context Staff << { c'1 | R1 } >>
  \header{ piece="Piece 2" }
}


