\version "2.22.2"

\header {
  texidoc = "
If you have several pieces in several files, you might want to build a
book from that. Assume you have a master file which includes the pieces:

@code{ \\include \"tune1.ly\" \\include \"tune2.ly\" }

In your piece-files you might have @code{\\tocItem} commands to build
the table of contents. If you replace those @code{\\tocItem} commands
with the newly defined @code{\\part} command, you can use
@code{#(set-toc-section! \"section\")} in the master file:


@code{ #(set-toc-section! \"tunes\") \\include \"tune1.ly\" \\include
\"tune2.ly\" #(set-toc-section! \"parts\") \\include \"part1.ly\"
\\include \"part2.ly\" }

Now every section is introduced with a section line in the table of
contents only if the section title was set before. If you reorder the
parts (includes), the sections will still appear in the right place.
This is meant for compiling a collection of pieces, which also compile
themselves. For a complete opus with pieces Please see snippet 368 

"
  doctitle = "Toc Section Command"
}
%% http://lsr.di.unimi.it/LSR/Item?id=738
%% see also http://lsr.di.unimi.it/LSR/Item?id=368

% define toc-section commands
#(begin 
  (define-public (set-toc-section! text) #f)
  (define-public (get-toc-section text) #f)
  (let ((toc-section #f))
       (set! set-toc-section! (lambda (text)(set! toc-section text)))
       (set! get-toc-section (lambda ()(begin toc-section)))))

% define section-aware piece-toc-item-command
piece = #(define-music-function (text) (markup?)
  (begin 
    (if (get-toc-section) (add-toc-item! 'tocCollMarkup (get-toc-section)))
    (set-toc-section! #f)
    (add-toc-item! 'tocPartMarkup text)))

\paper {
  #(set-paper-size "a5 landscape")
  % this will not know the page number!
  tocCollMarkup = \markup { \fill-line { \bold \fromproperty #'toc:text \vspace #1 \null } }
  tocPartMarkup = \markup { \fill-line { \concat { \hspace #2 \fromproperty #'toc:text } \vspace #0 \fromproperty #'toc:page } }
}


% some music pieces ...
\bookpart {
  \markuplist {
    \override-lines #'(baseline-skip . 2.3)
    \table-of-contents
  }
}
#(set-toc-section! "section 1")
\bookpart {
  \piece \markup { "piece 1" }
  \score {
    \relative c' {      
      c d e f g
    }
  }
}
\bookpart {
  \piece \markup { "piece 2" }
  \score {
    \relative c' {
      c d e f
    }
  }
}
#(set-toc-section! "section 2")
\bookpart {
  \piece \markup { "piece 1" }
  \score {
    \relative c' {
      c d e f
    }
  }
}
\bookpart {
  \piece \markup { "piece 2" }
  \score {
    \relative c' {
      c d e f
    }
  }
}



