\version "2.22.2"

\header {
  texidoc = "
Here is how to use custom-made symbols for harp muffle notation,
letting musicians know when to damp the strings with the palm of the
hands.  It may be printed more nicely between the lower and upper staff
by using the Dynamics context.

"
  doctitle = "Harp muffle notation"
}
mufflePath=
\markup
\path #0.15 #'((moveto -1.25 0)
                (lineto 1.25 0)
                (moveto 0 -1.25)
                (lineto 0 1.25))

muffleMarkup=
\markup \translate #'(0 . 1)
\combine \mufflePath
\draw-circle #1 #0.15 ##f

oMuffleMarkup=
\markup
\combine
\center-align \huge \bold \normal-text "O"
\center-align \translate #'(0 . 1)
\mufflePath


innerMuffleMarkup=
\markup \combine \muffleMarkup
\translate #'(0 . 1)
\draw-circle #.58 #0.15 ##f

muffle=#(make-dynamic-script muffleMarkup)
innerMuffle=#(make-dynamic-script innerMuffleMarkup)
oMuffle=#(make-dynamic-script oMuffleMarkup)

\new PianoStaff <<
  \new Staff {b1 b2 r b r b r \bar "|."}
  \new Dynamics {
    s1\p s2 r\oMuffle
    s r\muffle s2 r\innerMuffle
  }
  \new Staff {\clef bass e1 e2 r e r e r}
>>



