\version "2.22.2"

\header {
  texidoc = "
Curly bracket (or flat brace).

"
  doctitle = "Curly bracket with variable length (path)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=988
%% see also: http://lsr.di.unimi.it/LSR/Item?id=986
%% Credits: PPS on April 2015

%here starts the snippet:

%%% Defining a custom strait brace with a variable length:
#(define-markup-command (long-curly-bracket layout props arg-height)
   (number?)
  "Draw a curly bracket with a variable length."
     (interpret-markup layout props
       (markup
        #:translate (cons 0 (* arg-height -1))
        (#:with-dimensions (cons -0.001 0) (cons 0.001 0)
         (#:override (cons (quote filled) #t)
          (#:path 0.01 `(
           (moveto   -0.8   0.0)
           (curveto  -0.2   0.4  -0.3  0.7 -0.3  1.5)
           (lineto   -0.3   ,arg-height)
           (curveto  -0.4   ,(+ arg-height 1.3) 0.5 ,(+ arg-height 2.8) 0.7 ,(+ arg-height 2.8))
           (curveto   0.6   ,(+ arg-height 2.5) 0.1 ,(+ arg-height 2)   0.1 ,arg-height)
           (lineto    0.1   1.5)
           (curveto   0.1   0.7   0.1   0.0  -0.8   0.0)
           (closepath)
           (curveto  -0.2  -0.4  -0.3  -0.7  -0.3  -1.5)
           (lineto   -0.3   ,(* arg-height -1))
           (curveto  -0.4   ,(* (+ arg-height 1.3) -1) 0.5 ,(* (+ arg-height 2.8) -1) 0.7 ,(* (+ arg-height 2.8) -1))
           (curveto   0.6   ,(* (+ arg-height 2.5) -1) 0.1 ,(* (+ arg-height 2) -1)   0.1 ,(* arg-height -1))
           (lineto    0.1  -1.5)
           (curveto   0.1  -0.7   0.1   0.0  -0.8   0.0)
           (closepath))))))))

%%%% Examples:
\markup \with-dimensions #'(-1 . 110) #'(-95 . 3) \column {
  \italic "long-curly-bracket #Y:"
  \line {
    \center-column { "#2.5" \vspace #1 \long-curly-bracket #2.5 }
    \hspace #4
    \center-column { "#5" \vspace #1 \long-curly-bracket #5 }
    \hspace #4
    \center-column { "#10" \vspace #1 \long-curly-bracket #10 }
    \hspace #4
    \center-column { "#20" \vspace #1 \long-curly-bracket #20 }
    \hspace #4
    \center-column { "#40" \vspace #1 \long-curly-bracket #40 }
    \hspace #30
    \center-column { 
      "\\rotate #90 & #-90"
      \vspace #1
      "#3" 
      \rotate #90 \raise #3 \long-curly-bracket #3
      \vspace #1
      "#6" 
      \rotate #90 \raise #6 \long-curly-bracket #6
      \vspace #1
      "#12" 
      \rotate #90 \raise #12 \long-curly-bracket #12
      \vspace #1
      "#20" 
      \rotate #90 \raise #20 \long-curly-bracket #20
      \vspace #1
      "#30" 
      \rotate #90 \raise #30 \long-curly-bracket #30
      \vspace #1
      "#28" 
      \rotate #-90 \raise #28 \long-curly-bracket #28
      \vspace #1
      "#14" 
      \rotate #-90 \raise #14 \long-curly-bracket #14
      \vspace #1
      "#7" 
      \rotate #-90 \raise #7 \long-curly-bracket #7
      \vspace #1
      "#4" 
      \rotate #-90 \raise #4 \long-curly-bracket #4
      \vspace #1
      "#2" 
      \rotate #-90 \raise #2 \long-curly-bracket #2
    } 
  }
}

\paper { tagline = ##f }

