\version "2.22.2"

\header {
  texidoc = "
These note heads are used in contemporary guitar scores.
 The first one shows that the player should strike the strings sharply
at the head of the guitar with the left hand index.

 For the second one, he has to tab lightly on the table with any finger
of the right hand (similar to a light golpe).

Both note heads support svg output. 

"
  doctitle = "Percussive guitar note heads"
}
%% http://lsr.di.unimi.it/LSR/Item?id=987

% Credits P.P.Schneider on March 2015.

guitarHeadNotePath = 
      \markup
      %% X dimension has 0 value in order to hide the ledger lines.
      \with-dimensions #'(0 . 0) #'(-6.7 . 3)
      \path #0.1 
      #'((moveto    0.05   0.00)
         (lineto    0.85   2.50)
         (lineto   -0.75   2.50)
         (closepath)
         (moveto    0.69   2.00)
         (lineto    1.29   2.15)
         (lineto    1.29   1.85)
         (closepath)
         (moveto    0.53   1.50)
         (lineto    1.13   1.65)
         (lineto    1.13   1.35)
         (closepath)
         (moveto    0.37   1.00)
         (lineto    0.97   1.15)
         (lineto    0.97   0.85)
         (closepath)
         (moveto   -0.59   2.00)
         (lineto   -1.19   2.15)
         (lineto   -1.19   1.85)
         (closepath)
         (moveto   -0.43   1.50)
         (lineto   -1.03   1.65)
         (lineto   -1.03   1.35)
         (closepath)
         (moveto   -0.27   1.00)
         (lineto   -0.87   1.15)
         (lineto   -0.87   0.85)
         (closepath))
      
guitarHead = \once \override NoteHead.stencil = 
    #(lambda (grob) (grob-interpret-markup grob guitarHeadNotePath))
     
tabTablePath = 
    \markup
    \with-dimensions #'(0 . 0) #'(-4.3 . 2)
    \path #0.1 
          #'((moveto    0.05   0.00)
             (lineto    1.05   1.00)
             (moveto    1.05   0.00)
             (lineto    0.05   1.00))
          
tabTable = \once \override NoteHead.stencil = 
    #(lambda (grob) (grob-interpret-markup grob tabTablePath))

%%% Example:
\new Staff 
\with { 
  \omit Clef
  \omit TimeSignature
}
\relative c''' {
  %% Change note head stencil:
  \guitarHead c8[ 
  %% Since guitarHead has no X dimension, 
  %% scripts should be tweaked accordingly:
  -\tweak X-offset #.1 -> 
  % Put some space beetween notes:
  \grace { s8 s s s }
   %% Change note head stencil:
  \tabTable c8 
  %% Since tabTable has no X dimension, 
  %% scripts should be tweaked accordingly:
  -\tweak X-offset #.5 -.]
}


