\version "2.22.2"

\header {
  texidoc = "
By default it is the last alternative that stays single. This snippet
shows how to create a single first alternative using @code{\\tag} for
the midi output.




"
  doctitle = "Multiple repeats with alternate endings"
}
\paper { tagline = ##f }

\markup \italic "Default alternatives :"
\relative c' {
  c d e f
  \repeat volta 4 { d e f g }
  \alternative {
    { e f g a }
    { f g a b }
  }
  g a b c
  a
}

\markup\vspace #1
\markup\italic "Forcing the first alternative as single :"

myMusic = \relative c' {
  c d e f
  
  % this tag's for the pdf
  \tag myScore {
    \repeat volta 4 { d e f g }
    
    % 1st repeat alternative 
    \set Score.repeatCommands = #'((volta "1."))
    e f g a
    
    % 2nd to 4th repeats alternative
    \set Score.repeatCommands = #'((volta #f) (volta "2.--4.") end-repeat)
    f g a b
    \set Score.repeatCommands = #'((volta #f))
  }

  % this tag's for the midi
  \tag myMidi 
  \relative c' {
    d e f g
    e f g a
    \repeat volta 3 {
      d, e f g
      f g b c
    }
  }
  g a b c
  a
}


% Score output :
\score {
  \keepWithTag myScore \myMusic
  \layout {}
}

% Midi output :
\score {
  \unfoldRepeats
  \keepWithTag myMidi \myMusic
  \midi {}
}



