\version "2.22.2"

\header {
  texidoc = "
The following example shows how to obtain customized alterations. It is
achieved in three steps:

* Replace the alteration with a \\markup object (which is printed by
the text-interface) * Specify the \\markup itself (as we still want an
alteration to be printed, we have to use the \\musicglyph command) *
Add a \\postscript simple design in the markup, using simple commands
like @code{lineto} or @code{moveto}. Notice that the coordinates are to
be entered before each postscript command.

Such accidentals can be used to print semitones instead of the default
LilyPond glyphs. 

"
  doctitle = "Customized accidentals"
}
%% http://lsr.di.unimi.it/LSR/Item?id=378

upp =
#(define-music-function (note)   (ly:music?)
 #{ \once \override Voice.Accidental.stencil =
          #ly:text-interface::print
        \once \override Voice.Accidental.text =
          \markup {\musicglyph "accidentals.sharp"
       \postscript "gsave 0.17 setlinewidth -1.4 0.5 moveto -1.4 2 lineto
       stroke grestore
       gsave 0.1 setlinewidth -1.7 1.4 moveto -1.4 2.18 lineto -1.1 1.4 lineto
       stroke grestore"}
        $note #})
        
        
dwn =
#(define-music-function (note)   (ly:music?)
 #{ \once \override Voice.Accidental.stencil =
          #ly:text-interface::print
        \once \override Voice.Accidental.text =
          \markup {\musicglyph "accidentals.flat"
       \postscript "0.17 setlinewidth -2 0.5 moveto -0.6 1.8 lineto
       stroke "
       }
        $note #})
        
\relative c' {
       d \dwn bes d \upp gis
}







