\version "2.22.2"

\header {
  texidoc = "
Add a cautionary indication showing that the sustain pedal should
remain pressed after a line break. Syntax is
@code{[music]\\sustainSpanOn[music]\\sustainSpanOff}. 

This workaround uses @code{TextSpanner} instead of
@code{SustainPedal/PianoPedalBracket}. 

"
  doctitle = "Sustain pedal cautionary after line break"
}
%% http://lsr.di.unimi.it/LSR/Item?id=1023
%% Credits PPS => http://lilypond.1069038.n5.nabble.com/Sustain-pedal-cautionary-after-line-break-td186551.html

\paper { tagline = ##f }

%%%% Snippet start here:

%% Cautionary pedal mark after a line break:
cautionPed = \markup {
  \normal-text
  \with-dimensions #'(0 . 6) #'(0 . 1.8)
  \concat { 
    "(" 
    \musicglyph "pedal.Ped" 
    \musicglyph "pedal.." 
    ")" 
  }
}

ped = \markup {
  \concat {
    \musicglyph "pedal.Ped" 
    \musicglyph "pedal.." 
    \hspace #0.95
  }
}

%% Span:
sustainSpanOn = 
#(define-event-function ()()
    #{
      \tweak bound-details 
        #`((left . ((Y . 0)
                    (padding . -1.7)
                    (attach-dir . ,LEFT)
                    (stencil-align-dir-y . -1)
                    (text . ,ped)))
           (left-broken . ((attach-dir . ,RIGHT)
                           (text . ,cautionPed)
                           (padding . 0)))
           (right . ((Y . 0)
                     (attach-dir . ,LEFT)
                     (text . ,(markup #:draw-line (cons 0 1)))))
           (right-broken . ((padding . -0.2)
                            (text . #f))))
      \tweak padding #1.2
      \tweak direction #-1
      \tweak style #'line
      \startTextSpan 
   #})

sustainSpanOff = \stopTextSpan

%% Test:
\relative c'' { 
  c1\sustainSpanOn 
  \break
  c1 c1\sustainSpanOff
}


