\version "2.22.2"

\header {
  texidoc = "
 Predefined fretboard diagrams for the ukulele, so that authors can
simply write a chord name to get a fretboard with fingering hints, just
as with guitar music. Also includes a definition for ukulele-tunings
for the standard soprano tuning A-E-C-G, with which Lilypond is able to
autogenerate further fretboard diagrams for chords not defined here
(although these are not necessarily playable).




The fretboard diagrams are followed by a simple chord chart. Delete
that and include the rest of the file to use the diagrams in your own
scores.




These chord diagrams may give non-fatal compilation warnings with
Lilypond 2.12.2, but 2.13 has been patched to fix this (on 24 Nov 2009
by Carl Sorensen).




Proposed blurb for documentation:




\"Predefined fret diagrams\" subsection (from section 2.4.1)




The default predefined fret diagrams are contained in the file
predefined-guitar-fretboards.ly. Fret diagrams are stored based on the
pitches of a chord and the value of stringTunings currently in use.
predefined-guitar-fretboards.ly contains predefined fret diagrams only
for guitar-tuning.  To produce fret diagrams for the ukulele, use the
file predefined-ukulele-fretboards.ly:




  \\include \"predefined-ukulele-fretboards.ly\"

  myChords = @{ a1 a:m a:aug @}

  \\new ChordNames @{
    \\myChords
  @}

  \\new FretBoards @{
    \\set stringTunings = #ukulele-tuning
    \\myChords
  @}



Predefined fret diagrams can be added for other instruments or other
tunings by following these examples.




From lower down in the same subsection:




The predefined fret diagram table for guitar contains seven chords
(major, minor, augmented, diminished, dominant seventh, major seventh,
minor seventh) for each of 17 keys. The table for ukulele contains
these plus an additional four chords (major sixth, suspended second,
suspended fourth, and major ninth) for the same keys. In addition, the
file predefined-guitar-ninth-fretboards.ly contains major ninth chords
for guitar. A complete list of the predefined fret diagrams is shown in
Predefined fretboard diagrams. If there is no entry in the table for a
chord, the FretBoards engraver will calculate a fret-diagram using the
automatic fret diagram functionality described in Automatic fret
diagrams.




\"Predefined fretboard diagrams\" (section B.3)




I propose to copy the examples given here, except using @code{\\include
\"predefined-ukulele-fretboards.ly\"} plus @code{\\set stringTunings =
#ukulele-tuning}, and using these chords: @code{mychords = \\chordmode
@{c1 c:m c:aug c:dim c:7 c:maj7 c:m7 c:6 c:sus2 c:sus4 c:9 \\break @}}.
I also suggest adding \"predefined-guitar-ninth-fretboards.ly\" and
including @code{c:9} in the list of chords for the guitar.



"
  doctitle = "Predefined ukulele fretboards"
}
%% http://lsr.di.unimi.it/LSR/Item?id=649

% predefined-ukulele-fretboards.ly
%
% author: matt corks
% sources: ukulele hall of fame museum website (http://www.ukulele.org/),
% kiwi ukulele website (http://www.kiwiukulele.co.nz/)

% standard A-E-C-G soprano ukulele tuning
#(define-public ukulele-tuning '(9 4 0 7))

%%% a chords

\storePredefinedDiagram #default-fret-table \chordmode {a}
                        #ukulele-tuning 
                        #"2-2;1-1;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {a:m}
                        #ukulele-tuning 
                        #"2-1;o;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {a:7}
                        #ukulele-tuning
                        #"o;1-1;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {a:m7}
                        #ukulele-tuning
                        #"o;o;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {a:dim}
                        #ukulele-tuning
                        #"2-1;3-3;2-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {a:maj7}
                        #ukulele-tuning
                        #"1-1;1-2;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {a:6}
                        #ukulele-tuning
                        #"2-1;4-3;2-2;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {a:sus2}
                        #ukulele-tuning
                        #"2-2;4-3;5-4;2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {a:sus4}
                        #ukulele-tuning
                        #"2-1;2-2;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {a:aug}
                        #ukulele-tuning
                        #"2-2;1-1-(;1-1-);4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {a:9}
                        #ukulele-tuning
                        #"o;1-1;o;2-2;"

%%% ais chords

\storePredefinedDiagram #default-fret-table \chordmode {ais}
                        #ukulele-tuning
                        #"3-3;2-2;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:m}
                        #ukulele-tuning
                        #"3-3;1-1-(;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:7}
                        #ukulele-tuning
                        #"1-1-(;2-2;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:m7}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:dim}
                        #ukulele-tuning
                        #"o;1-1;o;1-2;"

\storePredefinedDiagram #default-fret-table \chordmode {ais:maj7}
                        #ukulele-tuning
                        #"2-2-(;2-2-);1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:6}
                        #ukulele-tuning
                        #"o;2-2;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:sus2}
                        #ukulele-tuning
                        #"3-3;o;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:sus4}
                        #ukulele-tuning
                        #"3-3-(;3-3-);1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ais:aug}
                        #ukulele-tuning
                        #"3-2;1-1-(;1-1-);5-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ais:9}
                        #ukulele-tuning
                        #"1-1-(;2-2;1-1-);3-3;"

%%% bes chords

\storePredefinedDiagram #default-fret-table \chordmode {bes}
                        #ukulele-tuning
                        #"3-3;2-2;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:m}
                        #ukulele-tuning
                        #"3-3;1-1-(;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:7}
                        #ukulele-tuning
                        #"1-1-(;2-2;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:m7}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:dim}
                        #ukulele-tuning
                        #"o;1-1;o;1-2;"

\storePredefinedDiagram #default-fret-table \chordmode {bes:maj7}
                        #ukulele-tuning
                        #"2-2-(;2-2-);1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:6}
                        #ukulele-tuning
                        #"o;2-2;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:sus2}
                        #ukulele-tuning
                        #"3-3;o;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:sus4}
                        #ukulele-tuning
                        #"3-3-(;3-3-);1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {bes:aug}
                        #ukulele-tuning
                        #"3-2;1-1-(;1-1-);5-4;"

\storePredefinedDiagram #default-fret-table \chordmode {bes:9}
                        #ukulele-tuning
                        #"1-1-(;2-2;1-1-);3-3;"

%%% b chords

\storePredefinedDiagram #default-fret-table \chordmode {b}
                        #ukulele-tuning 
                        #"4-3;3-2;2-1-(;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {b:m}
                        #ukulele-tuning 
                        #"4-3;2-1-(;2-1;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {b:7}
                        #ukulele-tuning
                        #"2-1-(;3-2;2-1;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {b:m7}
                        #ukulele-tuning
                        #"2-1-(;2-1;2-1;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {b:dim}
                        #ukulele-tuning
                        #"1-1;2-3;1-2;2-4;"

\storePredefinedDiagram #default-fret-table \chordmode {b:maj7}
                        #ukulele-tuning
                        #"3-2-(;3-2-);2-1-(;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {b:6}
                        #ukulele-tuning
                        #"1-1;3-4;2-2;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {b:sus2}
                        #ukulele-tuning
                        #"5-4;1-1;2-3;2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {b:sus4}
                        #ukulele-tuning
                        #"4-2-(;4-2-);2-1-(;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {b:aug}
                        #ukulele-tuning
                        #"o;3-2-(;3-2-);2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {b:9}
                        #ukulele-tuning
                        #"2-2-(;3-3;2-2-);4-4;"

%%% c chords

\storePredefinedDiagram #default-fret-table \chordmode {c}
                        #ukulele-tuning 
                        #"o;o;o;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {c:m}
                        #ukulele-tuning 
                        #"o;3-1;3-2;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {c:7}
                        #ukulele-tuning
                        #"o;o;o;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {c:m7}
                        #ukulele-tuning
                        #"3-1-(;3-1;3-1;3-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {c:dim}
                        #ukulele-tuning
                        #"2-1;3-3;2-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {c:maj7}
                        #ukulele-tuning
                        #"o;o;o;2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {c:6}
                        #ukulele-tuning
                        #"o;o;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {c:sus2}
                        #ukulele-tuning
                        #"o;2-1;3-2-(;3-2-);"

\storePredefinedDiagram #default-fret-table \chordmode {c:sus4}
                        #ukulele-tuning
                        #"o;o;1-1;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {c:aug}
                        #ukulele-tuning
                        #"1-1;o;o;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {c:9}
                        #ukulele-tuning
                        #"o;2-2;o;1-1;"

%%% cis chords

\storePredefinedDiagram #default-fret-table \chordmode {cis}
                        #ukulele-tuning 
                        #"1-1-(;1-1;1-1-);4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {cis:m}
                        #ukulele-tuning 
                        #"1-1;4-2;4-3-(;4-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {cis:7}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1-);2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {cis:m7}
                        #ukulele-tuning
                        #"2-2-(;2-2-);1-1;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {cis:dim}
                        #ukulele-tuning
                        #"o;1-1;o;1-2;"

\storePredefinedDiagram #default-fret-table \chordmode {cis:maj7}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1-);3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {cis:6}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {cis:sus2}
                        #ukulele-tuning
                        #"1-1;3-2;4-3-(;4-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {cis:sus4}
                        #ukulele-tuning
                        #"1-1-(;1-1-);2-2;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {cis:aug}
                        #ukulele-tuning
                        #"2-2;1-1-(;1-1-);4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {cis:9}
                        #ukulele-tuning
                        #"1-1-(;3-3;1-1-);2-2;"

%%% des chords

\storePredefinedDiagram #default-fret-table \chordmode {des}
                        #ukulele-tuning 
                        #"1-1-(;1-1;1-1-);4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {des:m}
                        #ukulele-tuning 
                        #"1-1;4-2;4-3-(;4-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {des:7}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1-);2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {des:m7}
                        #ukulele-tuning
                        #"2-2-(;2-2-);1-1;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {des:dim}
                        #ukulele-tuning
                        #"o;1-1;o;1-2;"

\storePredefinedDiagram #default-fret-table \chordmode {des:maj7}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1-);3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {des:6}
                        #ukulele-tuning
                        #"1-1-(;1-1;1-1;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {des:sus2}
                        #ukulele-tuning
                        #"1-1;3-2;4-3-(;4-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {des:sus4}
                        #ukulele-tuning
                        #"1-1-(;1-1-);2-2;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {des:aug}
                        #ukulele-tuning
                        #"2-2;1-1-(;1-1-);4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {des:9}
                        #ukulele-tuning
                        #"1-1-(;3-3;1-1-);2-2;"

%%% d chords

\storePredefinedDiagram #default-fret-table \chordmode {d}
                        #ukulele-tuning 
                        #"2-1;2-2;2-3;o;"

\storePredefinedDiagram #default-fret-table \chordmode {d:m}
                        #ukulele-tuning 
                        #"2-2-(;2-2-);1-1;o;"

\storePredefinedDiagram #default-fret-table \chordmode {d:7}
                        #ukulele-tuning
                        #"2-1-(;2-1;2-1-);3-2;"

\storePredefinedDiagram #default-fret-table \chordmode {d:m7}
                        #ukulele-tuning
                        #"2-2-(;2-2-);1-1;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {d:dim}
                        #ukulele-tuning
                        #"1-1;2-3;1-2;2-4;"

\storePredefinedDiagram #default-fret-table \chordmode {d:maj7}
                        #ukulele-tuning
                        #"2-1-(;2-1;2-1-);4-3;"

\storePredefinedDiagram #default-fret-table \chordmode {d:6}
                        #ukulele-tuning
                        #"2-1-(;2-1;2-1;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {d:sus2}
                        #ukulele-tuning
                        #"2-1;2-2;o;o;"

\storePredefinedDiagram #default-fret-table \chordmode {d:sus4}
                        #ukulele-tuning
                        #"o;2-1;3-2;o;"

\storePredefinedDiagram #default-fret-table \chordmode {d:aug}
                        #ukulele-tuning
                        #"3-2;2-1-(;2-1-);5-4;"

\storePredefinedDiagram #default-fret-table \chordmode {d:9}
                        #ukulele-tuning
                        #"2-1-(;4-3;2-1-);3-2;"

%%%% dis chords

\storePredefinedDiagram #default-fret-table \chordmode {dis}
                        #ukulele-tuning 
                        #"o;3-2-(;3-2-);1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:m}
                        #ukulele-tuning 
                        #"3-3-(;3-3-);2-2;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:7}
                        #ukulele-tuning
                        #"3-1-(;3-1;3-1-);4-2;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:m7}
                        #ukulele-tuning
                        #"3-2-(;3-2-);2-1;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:dim}
                        #ukulele-tuning
                        #"2-1;3-3;2-1;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:maj7}
                        #ukulele-tuning
                        #"3-1-(;3-2;3-1-);5-2;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:6}
                        #ukulele-tuning
                        #"3-1-(;3-1;3-1;3-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {dis:sus2}
                        #ukulele-tuning
                        #"3-2-(;3-2-);1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {dis:sus4}
                        #ukulele-tuning
                        #"1-2;3-3;4-4;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:aug}
                        #ukulele-tuning
                        #"o;3-2-(;3-2-);2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {dis:9}
                        #ukulele-tuning
                        #"o;1-1-(;1-1;1-1-);"

%%%% ees chords

\storePredefinedDiagram #default-fret-table \chordmode {ees}
                        #ukulele-tuning 
                        #"o;3-2-(;3-2-);1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:m}
                        #ukulele-tuning 
                        #"3-3-(;3-3-);2-2;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:7}
                        #ukulele-tuning
                        #"3-1-(;3-1;3-1-);4-2;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:m7}
                        #ukulele-tuning
                        #"3-2-(;3-2-);2-1;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:dim}
                        #ukulele-tuning
                        #"2-1;3-3;2-1;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:maj7}
                        #ukulele-tuning
                        #"3-1-(;3-2;3-1-);5-2;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:6}
                        #ukulele-tuning
                        #"3-1-(;3-1;3-1;3-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ees:sus2}
                        #ukulele-tuning
                        #"3-2-(;3-2-);1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {ees:sus4}
                        #ukulele-tuning
                        #"1-2;3-3;4-4;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:aug}
                        #ukulele-tuning
                        #"o;3-2-(;3-2-);2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {ees:9}
                        #ukulele-tuning
                        #"o;1-1-(;1-1;1-1-);"

%%%% e chords

\storePredefinedDiagram #default-fret-table \chordmode {e}
                        #ukulele-tuning 
                        #"4-2;4-3;4-4;2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {e:m}
                        #ukulele-tuning 
                        #"4-3;4-3;3-2;2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {e:7}
                        #ukulele-tuning
                        #"1-1;2-2;o;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {e:m7}
                        #ukulele-tuning
                        #"o;2-1;o;2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {e:dim}
                        #ukulele-tuning
                        #"o;1-1;o;1-2;"

\storePredefinedDiagram #default-fret-table \chordmode {e:maj7}
                        #ukulele-tuning
                        #"1-1;3-3;o;2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {e:6}
                        #ukulele-tuning
                        #"4-1-(;4-1;4-1;4-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {e:sus2}
                        #ukulele-tuning
                        #"4-3-(;4-3-);2-1-(;2-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {e:sus4}
                        #ukulele-tuning
                        #"2-2;4-4;o;2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {e:aug}
                        #ukulele-tuning
                        #"1-1;o;o;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {e:9}
                        #ukulele-tuning
                        #"1-1;2-2-(;2-2;2-2-);"

%%%% f chords

\storePredefinedDiagram #default-fret-table \chordmode {f}
                        #ukulele-tuning 
                        #"2-2;o;1-1;o;"

\storePredefinedDiagram #default-fret-table \chordmode {f:m}
                        #ukulele-tuning 
                        #"1-1;o;1-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {f:7}
                        #ukulele-tuning
                        #"2-2;3-3;1-1;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {f:m7}
                        #ukulele-tuning
                        #"1-1;3-3;1-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {f:dim}
                        #ukulele-tuning
                        #"1-1;2-3;1-2;2-4;"

\storePredefinedDiagram #default-fret-table \chordmode {f:maj7}
                        #ukulele-tuning
                        #"2-2;4-4;1-1;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {f:6}
                        #ukulele-tuning
                        #"2-2-(;2-2-);1-1;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {f:sus2}
                        #ukulele-tuning
                        #"o;o;1-1;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {f:sus4}
                        #ukulele-tuning
                        #"3-3;o;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {f:aug}
                        #ukulele-tuning
                        #"2-2;1-1-(;1-1-);4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {f:9}
                        #ukulele-tuning
                        #"2-1;3-2-(;3-2;3-2-);"

%%%% fis chords

\storePredefinedDiagram #default-fret-table \chordmode {fis}
                        #ukulele-tuning 
                        #"3-3;1-1;2-2;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:m}
                        #ukulele-tuning 
                        #"2-2;1-1;2-3;o;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:7}
                        #ukulele-tuning
                        #"3-3;4-4;2-2;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:m7}
                        #ukulele-tuning
                        #"2-1;4-3;2-2;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:dim}
                        #ukulele-tuning
                        #"2-1;3-3;2-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:maj7}
                        #ukulele-tuning
                        #"3-2;5-4;2-1;4-3;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:6}
                        #ukulele-tuning
                        #"3-2-(;3-2-);2-1;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:sus2}
                        #ukulele-tuning
                        #"1-1-(;1-1-);2-2;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:sus4}
                        #ukulele-tuning
                        #"4-4;1-1;2-2;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:aug}
                        #ukulele-tuning
                        #"3-2;2-1-(;2-1-);5-4;"

\storePredefinedDiagram #default-fret-table \chordmode {fis:9}
                        #ukulele-tuning
                        #"3-1;4-2-(;4-2;4-2-);"

%%%% ges chords

\storePredefinedDiagram #default-fret-table \chordmode {ges}
                        #ukulele-tuning 
                        #"3-3;1-1;2-2;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:m}
                        #ukulele-tuning 
                        #"2-2;1-1;2-3;o;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:7}
                        #ukulele-tuning
                        #"3-3;4-4;2-2;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:m7}
                        #ukulele-tuning
                        #"2-1;4-3;2-2;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:dim}
                        #ukulele-tuning
                        #"2-1;3-3;2-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:maj7}
                        #ukulele-tuning
                        #"3-2;5-4;2-1;4-3;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:6}
                        #ukulele-tuning
                        #"3-2-(;3-2-);2-1;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:sus2}
                        #ukulele-tuning
                        #"1-1-(;1-1-);2-2;4-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:sus4}
                        #ukulele-tuning
                        #"4-4;1-1;2-2;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:aug}
                        #ukulele-tuning
                        #"3-2;2-1-(;2-1-);5-4;"

\storePredefinedDiagram #default-fret-table \chordmode {ges:9}
                        #ukulele-tuning
                        #"3-1;4-2-(;4-2;4-2-);"

%%%% g chords

\storePredefinedDiagram #default-fret-table \chordmode {g}
                        #ukulele-tuning 
                        #"o;2-1;3-3;2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {g:m}
                        #ukulele-tuning 
                        #"o;2-2;3-3;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {g:7}
                        #ukulele-tuning
                        #"o;2-2;1-1;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {g:m7}
                        #ukulele-tuning
                        #"o;2-2;1-1-(;1-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {g:dim}
                        #ukulele-tuning
                        #"o;1-1;o;1-2;"

\storePredefinedDiagram #default-fret-table \chordmode {g:maj7}
                        #ukulele-tuning
                        #"o;2-1;2-2;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {g:6}
                        #ukulele-tuning
                        #"o;2-1;o;2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {g:sus2}
                        #ukulele-tuning
                        #"o;2-1;3-2;o;"

\storePredefinedDiagram #default-fret-table \chordmode {g:sus4}
                        #ukulele-tuning
                        #"o;2-1;3-2;3-3;"

\storePredefinedDiagram #default-fret-table \chordmode {g:aug}
                        #ukulele-tuning
                        #"o;3-2-(;3-2-);2-1;"

\storePredefinedDiagram #default-fret-table \chordmode {g:9}
                        #ukulele-tuning
                        #"2-2;2-3;1-1;2-4;"

%%%% gis chords

\storePredefinedDiagram #default-fret-table \chordmode {gis}
                        #ukulele-tuning 
                        #"5-3;3-1-(;4-2;3-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {gis:m}
                        #ukulele-tuning 
                        #"1-1;3-3;4-4;2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {gis:7}
                        #ukulele-tuning
                        #"1-1;3-3;2-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {gis:m7}
                        #ukulele-tuning
                        #"1-1;3-4;2-2;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {gis:dim}
                        #ukulele-tuning
                        #"1-1;2-3;1-2;2-4;"

\storePredefinedDiagram #default-fret-table \chordmode {gis:maj7}
                        #ukulele-tuning
                        #"1-1;3-2;3-3-(;3-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {gis:6}
                        #ukulele-tuning
                        #"1-1;3-3;1-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {gis:sus2}
                        #ukulele-tuning
                        #"1-2;3-3;4-4;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {gis:sus4}
                        #ukulele-tuning
                        #"1-1;2-3;4-3-(;4-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {gis:aug}
                        #ukulele-tuning
                        #"1-1;o;o;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {gis:9}
                        #ukulele-tuning
                        #"1-1;o;2-3;1-2;"

%%%% aes chords

\storePredefinedDiagram #default-fret-table \chordmode {aes}
                        #ukulele-tuning 
                        #"5-3;3-1-(;4-2;3-1-);"

\storePredefinedDiagram #default-fret-table \chordmode {aes:m}
                        #ukulele-tuning 
                        #"1-1;3-3;4-4;2-2;"

\storePredefinedDiagram #default-fret-table \chordmode {aes:7}
                        #ukulele-tuning
                        #"1-1;3-3;2-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {aes:m7}
                        #ukulele-tuning
                        #"1-1;3-4;2-2;2-3;"

\storePredefinedDiagram #default-fret-table \chordmode {aes:dim}
                        #ukulele-tuning
                        #"1-1;2-3;1-2;2-4;"

\storePredefinedDiagram #default-fret-table \chordmode {aes:maj7}
                        #ukulele-tuning
                        #"1-1;3-2;3-3-(;3-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {aes:6}
                        #ukulele-tuning
                        #"1-1;3-3;1-2;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {aes:sus2}
                        #ukulele-tuning
                        #"1-2;3-3;4-4;1-1;"

\storePredefinedDiagram #default-fret-table \chordmode {aes:sus4}
                        #ukulele-tuning
                        #"1-1;2-3;4-3-(;4-3-);"

\storePredefinedDiagram #default-fret-table \chordmode {aes:aug}
                        #ukulele-tuning
                        #"1-1;o;o;3-4;"

\storePredefinedDiagram #default-fret-table \chordmode {aes:9}
                        #ukulele-tuning
                        #"1-1;o;2-3;1-2;"

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% save everything above here as "predefined-ukulele-fretboards.ly",
%%% and include that file in your own sheet music to produce ukulele
%%% fretboards.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\header {
    title = "Soprano ukulele Chord Chart (A-E-C-G Tuning)"
}

myChords = \chordmode { 
  a1
  a:m
  a:7
  a:m7
  a:dim
  a:maj7
  a:6
  a:sus2
  a:sus4
  a:aug
  a:9
  \break
}

myChordSequence = {
                      \myChords
    \transpose a ais  \myChords
    \transpose a bes  \myChords
    \transpose a b    \myChords
    \transpose a c    \myChords
    \transpose a cis  \myChords
    \transpose a des  \myChords
    \transpose a d    \myChords
    \transpose a dis  \myChords
    \transpose a ees  \myChords
    \transpose a e    \myChords
    \transpose a f    \myChords
    \transpose a fis  \myChords
    \transpose a ges  \myChords
    \transpose a g    \myChords
    \transpose a gis  \myChords
    \transpose a aes  \myChords
}

<<
  \new ChordNames {
    \myChordSequence
  }

  \new FretBoards {
    \set Staff.stringTunings = #ukulele-tuning
    \myChordSequence
  }

  \new Staff {
    \override Staff.TimeSignature.transparent = ##t
    \myChordSequence
  }
>>

\layout {
  \context { \Score \remove "Bar_number_engraver" }
  papersize = "letter"
  indent = 0\mm
}



