\version "2.22.2"

\header {
  texidoc = "
There are different ideas of bar numbering: counting bars as written or
as played/heard. In other words: volta repeats might be counted only
once or as often as they are played. Only the former is officially
supported, but the latter is used by respectable publications such as
the Neue Bach-Ausgabe. This has also been reported in ensemble music
where some parts are printed with volta repeats whereas others (as well
as the conductor) are printed as @qq{unfolded}.


Here is a hack that increments the @code{currentBarNumber} property
whenever volta repeats occur. It also offers basic (though limited)
support for alternatives. 

"
  doctitle = "Incrementing bar numbers in volta repeats"
}
%% possible workaround for issue #5031 -vv
%% Limitations may (and will) occur for complex
%% cases with multiple alternatives.

%% Due to heavily changed and extended internals for \repeat volta the
%% former 2.22.2-code is replaced by an engraver. As bonus this engravers covers
%% more cases of complex alternatives --harm

Unfold_bar_numbers_engraver =
  #(lambda (ctx)
     (let* ((repeat-start #f)
            (alternative-starts '())
            (repeat-count #f))
       (make-engraver
         (listeners
           ((volta-repeat-start-event engraver event)
             ;; A \repeat volta <number> { ... } starts.
             ;; Get and store 'repeat-count and 'currentBarNumber.
             ;; At this point of time it's not yet know whether alternatives
             ;; will occurr.
             (set! repeat-count
                   (ly:event-property event 'repeat-count))
             (set! repeat-start
                   (ly:context-property ctx 'currentBarNumber)))

           ((volta-span-event engraver event)
             ;; If 'volta-span-event happens, alternatives are present.
             ;; Get and store (in a accumulates list) the bar numbers
             ;; when an alternative starts.
             (let ((volta-numbers (ly:event-property event 'volta-numbers)))
               (set! alternative-starts
                     (cons
                       (ly:context-property ctx 'currentBarNumber)
                       alternative-starts))))

           ((volta-repeat-end-event engraver event)
             ;; 'volta-repeat-end-event is triggered at the end of the first
             ;; alternative or at the end of the repeat-setion, if no
             ;; alternatives are present.
             ;; For bar numbering this means we need to know the lengths of
             ;; the alternatives and the length of repeat-start to begin of
             ;; first alternative.
             (let* ((curr-bar-number
                      (ly:context-property ctx 'currentBarNumber))
                    ;; We call 'alternative-number in order to know whether
                    ;; alternatives are present at all.
                    (alternative-number
                      (ly:event-property event 'alternative-number #f))
                    ;; We call 'return-count to know how often a certain
                    ;; alternative is repeated.
                    (return-count (ly:event-property event 'return-count))
                    ;; Drop bar-numbers lower than the start of current
                    ;; repeat.
                    (relevant-alternative-starts
                      (filter
                        (lambda (x)
                          (> x repeat-start))
                        alternative-starts))
                    ;; If we have alternatives, calculate their lengths.
                    (relevant-alternative-lengths
                      (let lp ((vals-list relevant-alternative-starts))
                        (if (or (null? vals-list) (odd? (length vals-list)))
                            '()
                            (cons
                              (- (car vals-list) (cadr vals-list))
                              (lp (drop vals-list 2))))))
                    ;; Get the length of the repeat body, without first
                    ;; alternative, if present.
                    (body-length
                       (-
                          (if alternative-number
                              (last relevant-alternative-starts)
                              curr-bar-number)
                          repeat-start)))

               (ly:context-set-property! ctx 'currentBarNumber
                 (+
                    curr-bar-number
                    (* body-length return-count)
                    (*
                      (if (pair? relevant-alternative-lengths)
                          (last relevant-alternative-lengths)
                          0)
                      (1- return-count))))))))))

mus = {
  b1
  \repeat volta 4 { c'1 c' }
  \alternative {
    { b b }
    { d' d' d' }
    { e' e' e' e' }
  }
  b
  \repeat volta 3 { c' c' d' }
  \alternative {
    { b b }
    { f' }
  }
  b
  \bar "|."
}

\score {
  \mus
  \layout {
    \context {
      \Score
      \consists
      \Unfold_bar_numbers_engraver
      \override BarNumber.break-visibility = ##(#f #t #t)
    }
  }
}

\score {
  \unfoldRepeats \mus
  \layout {
    \context {
      \Score
      \override BarNumber.break-visibility = ##(#f #t #t)
    }
  }
}

\paper { tagline = ##f }

