\version "2.22.2"

\header {
  texidoc = "
Sometimes you may want to know all properties and their values for a
certain grob.  The here provided function is a possibility.  Afaict,
following comment is not true (any more?), will delete soon --Harm:
Known limitation: it doesn't work for NoteHead. The output is like:




* Grob ChordName: *  * GROB-INTERFACE *     ...(shortened) *
CHORD-NAME-INTERFACE *  * 	begin-of-line-visible: * 	() *
FONT-INTERFACE *  * 	font: * 	() * 	font-encoding: * 	() *
	font-family: * 	sans * 	font-name: * 	() * 	font-series: * 	() *
	font-shape: * 	() * 	font-size: * 	1.5 * ITEM-INTERFACE *  *
	break-visibility: * 	() * 	extra-spacing-height: * 	(0.2 . -0.2) *
	extra-spacing-width: * 	(-0.5 . 0.5) * 	non-musical: * 	() *
RHYTHMIC-GROB-INTERFACE *  * TEXT-INTERFACE *  * 	baseline-skip: * 	()
* 	replacement-alist: * 	() * 	text: * 	... (shortened) * 	word-space:
* 	0.0 * 	text-direction: * 	()

for this coding:

\\new ChordNames
  \\chordmode @{
    \\grobPropertiesInfo #'ChordName
    c1:m7
  @} 

"
  doctitle = "Displaying all grob properties and their actual values"
}
#(define (supported-properties iface)
  (let ((iface-info (hashq-get-handle (ly:all-grob-interfaces) iface)))
    (last iface-info)))

#(define print-all-grob-properties-key-values
  (grob-transformer 'after-line-breaking
   (lambda (grob orig) 
    (let ((ifaces (assoc-get 'interfaces (ly:grob-property grob 'meta))))
      (format #t "\n~a:\n" grob)
      (for-each
        (lambda (iface)
          (format #t "\n~a\n" (string-upcase (symbol->string iface)))
            (for-each
              (lambda (p)
                (format #t "\n\t~a:\n\t~a" p 
                  (if (eq? p 'after-line-breaking)
                      orig
                      (ly:grob-property grob p))))
              (supported-properties iface)))
        ifaces)
      orig))))
      
grobPropertiesInfo =
#(define-music-function (grob-name)(symbol?)
#{
  \override $grob-name . after-line-breaking =
    #print-all-grob-properties-key-values
#})
 
\new ChordNames
  \chordmode {
    \grobPropertiesInfo #'ChordName
    c1:m7
  }


