\version "2.22.2"

\header {
  texidoc = "
This situation seems to come up when the following conditions are met:

* We are using a global @qq{invisible} voice in every staff for line
breaking. * The music in one or more staves is compressed so that its
barlines are out of sync with the barlines of the global voice.


The problem is that although notes and ordinary rests compress in the
offending staves, full measure rests adhere to the time of the global
voice.

The solution is to scale the \\time value for offending staves by a
fraction of the global voice full-measure rest length.

In the example below, there are nine 3/8 measures in the time of four
3/8 measures.  The nine are therefore compressed by 4/9ths.  To get
appropriate length full-measure rests in the nine, we must set the
\\time value for the nine bars to 4/9ths of 3/8, or 1/6.

We can then display a @qq{dummy} 3/8 time signature.

You can see the error by replacing the 1/6 with 3/8 in the
compressMusic block.



"
  doctitle = "Polymetric section: printing full-measure rests"
}
%% http://lsr.di.unimi.it/LSR/Item?id=329

\paper { 	
  ragged-right = ##t
}

\layout { 
  \context { 
    \Score
    \remove "Timing_translator"
    \remove "Time_signature_engraver"
    \override SpacingSpanner.uniform-stretching = ##t
    \override SpacingSpanner.strict-note-spacing = ##t
    proportionalNotationDuration = #(ly:make-moment 1/64)
  }
  \context { 
    \Staff
  \consists "Timing_translator"
  \consists "Time_signature_engraver"
  }
}

global = { 
  \set Timing.measureBarType = ""
  \repeat unfold 4 { s4. } \bar "" \break
}

\new Score { <<
  \new StaffGroup { <<
    \new Staff <<
      \global
      {
        \time 3/8
        \repeat unfold 2 { R4. \bar "|" c'8[c'8 c'8] \bar "|" } 
      }
    >>
    \new Staff <<
      \global
      {
        \scaleDurations #'(4 . 9) { 
          \time 1/6
          \set Staff.timeSignatureFraction = #'(3 . 8)
          \repeat unfold 3 { R4. \bar "|" c'8[c'8 c'8] \bar "|" R4. \bar "|"}
        }	
      }
    >>
  >> }

>> }




