\version "2.22.2"

\header {
  texidoc = "
This snippet shows a way to insert available Feta font symbols as
caesurae and ways to create tramlines.  Normally a caesura is indicated
by a pair of oblique lines lying through the top line of the staff,
also called a fetura, tramlines, railroad tracks, or a cut-off. 
LilyPond provides several alternatives.  A stylized version of
tramlines is called caesura.

"
  doctitle = "Tramlines and Feta font caesurae"
}
%% http://lsr.di.unimi.it/LSR/Item?id=195
%% see also http://lsr.di.unimi.it/LSR/Item?id=454
%% see also http://lsr.di.unimi.it/LSR/Item?id=170
%% see also http://lsr.di.unimi.it/LSR/Item?id=403
%% see also http://lsr.di.unimi.it/LSR/Item?id=640
%% see also http://lsr.di.unimi.it/LSR/Item?id=213

\layout{
  indent = 0.00\in
  ragged-right = ##f
}

\relative c'' {
  \time 3/4
  % by default, \breathe uses the rcomma, just as if saying:
  % \override BreathingSign.text = \markup { \musicglyph "scripts.rcomma" }
  e4_\markup "default" \breathe d e |
  % lcomma
  \override BreathingSign.text =  \markup { \musicglyph "scripts.lcomma" }
  e_\markup "lcomma" \breathe d e |
  % caesura.curved
  \override BreathingSign.text =  \markup { \musicglyph "scripts.caesura.curved" }
  e_\markup "caesura.curved" \breathe d e |
  % caesura.straight, or railroad tracks
  \override BreathingSign.text =  \markup { \musicglyph "scripts.caesura.straight" }
  e_\markup "caesura.straight" \breathe d e | 
  % tickmark
  \override BreathingSign.text =  \markup { \musicglyph "scripts.tickmark" }
  e_\markup "tickmark" \breathe d e |
  
  \break
  
  % rvarcomma
  \override BreathingSign.text =  \markup { \musicglyph "scripts.rvarcomma" }
  e_\markup "rvarcomma" \breathe d e |
  % lvarcomma
  \override BreathingSign.text =  \markup { \musicglyph "scripts.lvarcomma" }
  e_\markup "lvarcomma" \breathe d e |
  % a custom mark
  \override BreathingSign.text =  \markup { \fontsize #4 \vcenter \bold "’" }
  e_\markup "custom mark" \breathe d e |
}


