\version "2.22.2"

\header {
  texidoc = "
If you want to create a custom shape or symbol, you can use the
@code{make-connected-path-stencil} scheme function.  This function
takes the following six arguments, and returns a @code{stencil}.


1. A list of lists defining the coordinates of the path.  The path
automatically starts at the origin point of (0 0).  To draw a straight
line to the next point, simply indicate the X and Y coordinates of the
next point like this: @code{(1 -3)}  To draw a cubic Bézier curve to
the next point, enter a list of six numbers like this: @code{(-6 -2 -6
7 0 5)}  The first two numbers are the X and Y coordinates of the first
control point. The middle two are the X and Y coordinates of the second
control point.  The last two are the X and Y coordinates of the
destination point.


2. A number indicating the thickness of the line.


3. A number that scales the stencil on the X-axis.


4. A number that scales the stencil on the Y-axis.


5. A boolean (#t / #f) indicating whether the path automatically
connects back to the origin point (0 0).


6. A boolean (#t / #f) indicating whether the shape created by the path
is to be filled.


This snippet demonstrates using @code{stencils} as an override for
other @code{stencils}, and also how they can be used in 
@code{\\markup}.  The snippet also shows how to use
@code{ly:stencil-translate} to shift the position of the stencil. This
is sometimes needed since the origin point of the path is
\"hard-coded\" to always be (0 0).


Using @code{make-connected-path-stencil} has several advantages
compared with using @code{ly:make-stencil} and @code{path} (as shown
here: http://lsr.di.unimi.it/LSR/Item?id=623).  One is that you do not
have to manually specify the width and height of the stencil, since it
gets calculated automatically. 

"
  doctitle = "Using make-connected-path-stencil to draw custom shapes"
}
%% http://lsr.di.unimi.it/LSR/Item?id=891

\paper { tagline = ##f }

bowtie = 
#(make-connected-path-stencil
  '((0 0.5)  ;; path coordinates
    (0.5 0 1.0 0 1.5 0.5)
    (1.5 -0.5)
    (1.0 0 0.5 0 0 -0.5)
    (0 0))
  0.1  ;; line thickness
  1  ;; X-axis scaling factor
  1  ;; Y-axis scaling factor
  #f  ;; automatically connect path to origin point? (0 0)
  #t)  % filled path?
  
{ \override NoteHead.stencil = \bowtie e'4 f' g' a' }


triangle = 
\markup \stencil 
#(make-connected-path-stencil
  '((1 2)  ;; path coordinates
    (2 0)
    (0 0))
  0.15  ;; line thickness
  1  ;; X-axis scaling factor
  1  ;; Y-axis scaling factor
  #f  ;; auto-connect path to origin point? (0 0)
  #t)  % filled path?

moon =
\markup \stencil
#(ly:stencil-translate
  (make-connected-path-stencil
   '((-6 -2 -6 7 0 5) 
     (-3 5 -3 0 0 0))
   0.15 
   0.5 
   0.5 
   #f 
   #f) 
  (cons 1.8 0)) % ly:stencil-translate coordinates

{ c'4 \mark \triangle c'4 c'4  c'4^\moon }




