\version "2.22.2"

\header {
  texidoc = "
Sometimes you want to encode staffs without braces which has the effect
that the bar lines are aligned. See also snippet 873: Vertical aligned
StaffGroups without connecting SystemStartBar

"
  doctitle = "PianoStaff without Braces"
}
\paper { indent = 30 }

scale = \relative c' {
  a4 b c d
  e4 f g a
}

%% System_start_delimiter_engraver is part of the following context(s):
%% ChoirStaff, GrandStaff, PianoStaff, Score and StaffGroup.

%% Either remove the engraver from the relevant contexts
\layout {
  \context {
    \Score
    %% don't print SystemStartBar
    \remove "System_start_delimiter_engraver"
  }
  \context {
    \PianoStaff
    %% don't print SystemStartBrace for PianoStaff
    %% SystemStartBrace is still printed for GrandStaff
    \remove "System_start_delimiter_engraver"
  }
}

%% Or do it more selectively by omitting the relevant grobs.
%
%\layout {
%  \context {
%    \Score
%    \omit SystemStartBar   
%  }
%  \context {
%    \PianoStaff
%    %% omitting SystemStartBrace here and not at Score-level is even more
%    %% selective (SystemStartBrace is still printed for GrandStaff)
%    \omit SystemStartBrace
%  }
%}
%

music =
  <<
   \new Staff { \scale \transpose c d \scale }
   \new Staff { \scale \transpose c e \scale }
   \new Staff { \scale \transpose c f \scale }
  >>

<<
  \new PianoStaff 
  \with { 
    instrumentName = 
      \markup 
        \center-column {
          "SystemStartBrace" "is omitted" "for" "PianoStaff"
        }
  }
  \music
   
  \new GrandStaff 
  \with { 
    instrumentName = 
      \markup 
        \center-column {
          "SystemStartBrace" "is printed" "for" "GrandStaff"
        }
  }
  \music
>>


