\version "2.22.2"

\header {
  texidoc = "
In an orchestral score, you may find it useful to hide multi-bar rests
using @code{\\RemoveEmptyStaffContext} to produce a @qq{Frenched}
score, but this can prove problematic when you want to make such bars
visible.


For example, imagine you are using a @code{PianoStaff} for a harp part.
When there is music in one stave, you will want both staves to be
visible. Of course, adding hidden notes to the invisible staff will
make the stave visible, but this is a rather ugly kludge.


A more elegant solution is to use the property
@code{keepAliveInterfaces}. This determines which items of musical
output are interesting enough to keep a bar visible when
@code{remove-empty} is set. By default, it looks like this:


@code{keepAliveInterfaces = #'(
    rhythmic-grob-interface
    lyric-interface
    stanza-number-interface
    percent-repeat-interface)}


If you insert @code{multi-measure-rest-interface} into this list,
multi-bar rests count as interesting items. You can then create macros
to switch this behaviour on and off as required:


@code{showMultiRests = @{ \\set Staff.keepAliveInterfaces = #'(
    rhythmic-grob-interface
    multi-measure-rest-interface
    lyric-interface
    stanza-number-interface
    percent-repeat-interface) @}}


@code{hideMultiRests = \\unset Staff.keepAliveInterfaces}


For this to work successfully, you must place these macros carefully,
otherwise they tend to interfere with the visibility of other hidden
staves. 

"
  doctitle = "Forcing visibility of systems with multi-bar rests when using \\RemoveEmptyStaffContext"
}
%% http://lsr.di.unimi.it/LSR/Item?id=312

\paper { tagline = ##f }

showMultiRests = {
 \set Staff.keepAliveInterfaces = #'(
    rhythmic-grob-interface
    multi-measure-rest-interface
    lyric-interface
    stanza-number-interface
    percent-repeat-interface)
}
hideMultiRests = \unset Staff.keepAliveInterfaces
one = {
 \repeat unfold 4 { a1 b c' d' \break }
 % Macro positioning is critical - overrides are inside each system
 %i.e. after first rest and before last
 R1 \showMultiRests R R \hideMultiRests R \break
 R1*4 \break
 R
}
two = {
 \override MultiMeasureRest.color = #red
 R1*4
 R1 \showMultiRests R R \hideMultiRests R
 R1*4
 R
 R1 \showMultiRests R R R
 R R R \hideMultiRests R
 R1*4
}
three = {
 \override MultiMeasureRest.color = #blue
 R1*4
 R
 R1 \showMultiRests R R \hideMultiRests R
 R1*4
 R1 \showMultiRests R R \hideMultiRests R
 R1*4
 R1 \showMultiRests R R R
}
\score {
 \new StaffGroup { <<
  \context Staff = one \one
  \context Staff = two \two
  \context Staff = three \three
  >>
 }
 \layout {
  \context { \Staff \RemoveEmptyStaves }
 }
}



