\version "2.22.2"

\header {
  texidoc = "
When an instrument has no music for the remainder of a piece or
movement, it is common to put a single multi-measure rest with a “tacet
al fine” marking, which suppresses/replaces all music changes (time
signatures, key signatures, rehearsal marks, etc.). This snippet
demonstrates how to truncate a musical expression at a given measure
and simply append a “tacet al fine” measure.

"
  doctitle = "Creating a “tacet al fine” rest"
}
\version "2.24.0"

global = {
  \key c \major
  s1*4
  \bar "||"
  \mark \default
  \time 3/4
  \key d \major
  s2.*4
  \bar "||"
  \mark \default
  \time 4/4
  \key e \major
  s1*4
  \bar "|."
}

tacetAlFine = {
  \omit Score.TimeSignature \time 4/4
  \override MultiMeasureRest.expand-limit = 0
  \override MultiMeasureRest.minimum-length = 16
  \override MultiMeasureRestText.padding = #1
  R1^\markup \bold "Tacet al fine"
  \bar "|."
}

tuba = {
  \clef bass
  c,,4-. r r2
  R1*3
  R2.*4
  R1*4
}

tubaPart = { << \global \tuba >> }
\addQuote "tubaPart" \tubaPart

\markup "Full Tuba part:"
\tubaPart

\markup \vspace #4
\markup "“Tacet” Tuba part:"
\new Staff { \clef bass \quoteDuring "tubaPart" s1 \tacetAlFine }

\paper { tagline = ##f }

