\version "2.22.2"

\header {
  texidoc = "
By default, the @code{NoteNames} also adds a note name for a tied note.
To avoid that, you can use a scheme music function which will transform
all second notes of tied notes to a @code{\\skip} event.



"
  doctitle = "Preventing NoteNames adding a note name for a tied note"
}
%% http://lsr.di.unimi.it/LSR/Item?id=760

%LSR by Gilles Thibault

#(define (name-of music) (ly:music-property music 'name))

tiedNoteToSkip = #(define-music-function (music) (ly:music?)
(let ((prev-was-tie? #f))
  (map-some-music 
   (lambda (evt)
     (cond ((memq (name-of evt) '(EventChord NoteEvent))
               (let ((old-flag prev-was-tie?))
                  (set! prev-was-tie? #f)
                  (let ((res (music-filter (lambda(x)
                                (or (not (eq? (name-of x) 'TieEvent))
                                    (begin (set! prev-was-tie? #t)
                                            #f)))
                                evt)))
                    (if old-flag (skip-of-length evt) res))))          
           (else (ly:music-property music 'duration #f)))) 
    music)))

mymusic = { e'4 d' ~ d'~  d' c'1}

\score {
 <<
 \new Voice \mymusic
 \context NoteNames \tiedNoteToSkip \mymusic
 >>
}



