\version "2.22.2"

\header {
  texidoc = "
When a glissando crosses a G or F clef, the @code{\\whiteout} function
does not hide it properly.


Here are two clef-combining stencils that offer something more
accurate. 

"
  doctitle = "Hiding part of a glissando when clashing a clef"
}
%% http://lsr.di.unimi.it/LSR/Item?id=886

%LSR by P.P.Schneider

%here starts the snippet:

#(set-global-staff-size 25)

GlissCrossClefG = {
    \once \override Staff.Clef.stencil = #ly:text-interface::print
    \once \override Staff.Clef.text = 
    \markup {  
        \combine
          \postscript " 1.1 4.2 moveto
              2 3.5 1.9 2.3 1.25 1.5 curveto
              1.4 1 lineto
              2.1 1 2.9 -0.1 1.7 -1.05 curveto
              1.7 -1.4 1.9 -1.7 1.1 -2.2 curveto
              0 -2.3 -0.25 -1.6 0.1 -1 curveto
              0.3 -0.9 lineto
              0.3 -0.8 lineto
              0.2 -0.8 -1.1 0.5 0.5 1.8 curveto
              0.5 1.8 0 3.5 1 4.2 curveto
              closepath
  	      1 setgray	
              fill"
          \musicglyph "clefs.G_change" 
    }
    \clef G
}

GlissCrossClefF = {
    \once \override Staff.Clef.stencil = #ly:text-interface::print
    \once \override Staff.Clef.text = 
    \markup {  
        \combine
          \postscript " -0.2 -0.3 moveto
              -0.5 0.9  0.4 1.6  1.7 0.8 curveto
              2.0 0.8 lineto
              2.25 0.6 lineto
              2.25 -0.5 lineto
              2.0 -0.75 lineto
              1.65 -0.75 lineto
              1.65 -0.75  0.9 -1.7  -0.1 -1.8 curveto
              -0.1 -1.8 -0.5 -1.7 -0.3 -1.5 curveto
              0 -0.7 lineto
              0.6 -0.6 lineto
              0.7 -0.4 lineto
              0.4 -0.5 lineto
              closepath
  	      1 setgray	
              fill"
          \musicglyph "clefs.F_change" 
    }
    \clef F
}

\score {
  \new Staff {
    \override Score.StaffSymbol.layer = #3
    \override Staff.Clef.layer = #2
    \clef F
    \time 4/4
    \cadenzaOn
    \set glissandoMap = #'((2 . 0) (1 . 1) (0 . 2))
    \once\override TextScript.extra-offset = #'(-3 . 1) 
    <e, c c'>1 ^\markup\column {
                   \vspace #1 %% LSR-problem-workaround
                   \line { "Using" \italic "whiteout" ":"} }
    \glissando
    \once \override Staff.Clef.whiteout = ##t 
    \clef G 
    <a c'' c'''>
    \bar "||"
    \stopStaff
    s1
    \startStaff
    \override Score.StaffSymbol.layer = #3
    \override Score.Glissando.layer = #2
    \once\override Staff.Clef.full-size-change = ##t
    \clef F
    \time 4/4
    \set glissandoMap = #'((2 . 0) (1 . 1) (0 . 2))
    \once\override TextScript.extra-offset = #'(-2 . 1) 
    <e, c c'>1^\markup { "New stencil :"}  \glissando
    \GlissCrossClefG
    <a c'' c'''>
    \cadenzaOff
    \bar "||"
  }
  \layout {
    indent = #0
    \context {
      \Staff
      \override TimeSignature.transparent = ##t
    }
  }
}

\score {
  \new Staff {
    \override Score.StaffSymbol.layer = #3
    \override Staff.Clef.layer = #2
    \clef G
    \time 4/4
    \cadenzaOn
    \set glissandoMap = #'((2 . 0) (1 . 1) (0 . 2))
    <c' c'' c'''>1 \glissando
    \once \override Staff.Clef.whiteout = ##t 
    \clef F
    <c, c c'>1 
    \bar "||"
    \stopStaff
    s1
    \startStaff
    \override Score.StaffSymbol.layer = #3
    \override Score.Glissando.layer = #0
    \once\override Staff.Clef.full-size-change = ##t
    \clef G
    \time 4/4
    \set glissandoMap = #'((2 . 0) (1 . 1) (0 . 2))
    <c' c'' c'''>\glissando
    \GlissCrossClefF
    <c, c c'>1 
    \cadenzaOff
    \bar "||"
  }
  \layout {
    indent = #0
    \context {
      \Staff
      \override TimeSignature.transparent = ##t
    }
  }
}

\paper { tagline = ##f }

