\version "2.22.2"

\header {
  texidoc = "
Normally, LilyPond refuses to automatically break a line at places
where a glissando crosses a bar line.  This behavior can be changed by
setting the @code{Glissando.breakable} property to @code{#t}.  Also
setting the @code{after-line-breaking} property to @code{#t} makes the
glissando line continue after the break.


The @code{breakable} property does not affect manual breaks inserted
with commands like @code{\\break}.




"
  doctitle = "Making glissandi breakable"
}
glissandoSkipOn = {
  \override NoteColumn.glissando-skip = ##t
  \hide NoteHead
  \override NoteHead.no-ledgers = ##t
}

music = {
  \repeat unfold 16 f8 |
  f1\glissando |
  a4 r2. |
  \repeat unfold 16 f8 |
  f1\glissando \once\glissandoSkipOn |
  a2 a4 r4 |
  \repeat unfold 16 f8
}

\relative c'' {
  <>^\markup { \typewriter Glissando.breakable
               set to \typewriter "#t" }
  \override Glissando.breakable = ##t
  \override Glissando.after-line-breaking = ##t
  \music
}

\relative c'' {
  <>^\markup { \typewriter Glissando.breakable not set }
  \music
}

\paper {
  line-width = 100\mm
  indent = 0
  tagline = ##f
}

